(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    292939,       9015]*)
(*NotebookOutlinePosition[    293657,       9040]*)
(*  CellTagsIndexPosition[    293613,       9036]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Direction Field and Solution Curves--\nSeparable Equations\n",
  StyleBox["C. C. Ross \n",
    FontSize->16],
  StyleBox["January 24-27, 2002\nModified October 28-30, 2002",
    FontSize->10]
}], "Subtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Definitions of ",
  Cell[BoxData[
      \(dy\/dx == yf[x, y]\/xf[x, y]\)]]
}], "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(yf[x_, y_] = 4  x^2 + 9  y^2 - 13\)], "Input",
  CellFrame->True,
  Background->RGBColor[0.985565, 1, 0.0107271]],

Cell[BoxData[
    \(\(-13\) + 4\ x\^2 + 9\ y\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xf[x_, y_] = \((9  x^2 + 4  y^2 - 13)\)\)], "Input",
  CellFrame->True,
  Background->RGBColor[1, 0.982238, 0.0196994]],

Cell[BoxData[
    \(\(-13\) + 9\ x\^2 + 4\ y\^2\)], "Output"]
}, Open  ]],

Cell["\<\
Define the intervals containing x and y:   Change the  appropriate \
items.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extents[{x, \(-2\), 2}, {y, \(-2\), 2}]\)], "Input",
  CellFrame->True,
  Background->RGBColor[1, 0.994034, 0],
  Magnification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-2\) \[LessEqual] x \[LessEqual] 2\)},
          {\(\(-2\) \[LessEqual] y \[LessEqual] 2\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        LessEqual[ -2, x, 2], 
        LessEqual[ -2, y, 2]}],
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check", "Subsection"],

Cell["Verify that either this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dy\/dx == yf[x, y]\/xf[x, y] // TraditionalForm\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dx \[Equal] \(4\ x\^2 + 9\ y\^2 - 13\)\/\(9\ x\^2 \
+ 4\ y\^2 - 13\)\)], "Output"]
}, Open  ]],

Cell["or this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{\(y'\)[t] == yf[x[t], y[t]], \(x'\)[t] == xf[x[t], y[t]]}] // 
      TraditionalForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "\[Equal]", \(4\ \(x(t)\)\^2 + 9\ \(y(t)\)\^2 - 13\)}]},
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "\[Equal]", \(9\ \(x(t)\)\^2 + 4\ \(y(t)\)\^2 - 13\)}]}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {
          Equal[ 
            Derivative[ 1][ y][ t], 
            Plus[ -13, 
              Times[ 4, 
                Power[ 
                  x[ t], 2]], 
              Times[ 9, 
                Power[ 
                  y[ t], 2]]]], 
          Equal[ 
            Derivative[ 1][ x][ t], 
            Plus[ -13, 
              Times[ 9, 
                Power[ 
                  x[ t], 2]], 
              Times[ 4, 
                Power[ 
                  y[ t], 2]]]]}],
        Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell["is a correct representation of your differential equation.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Vector Field", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DirFld = 
        PlotVectorField[xf[x, y], 
          yf[x, y], {x, xL, xR, 20}, {y, yB, yT, 20}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.2316 0.5 0.2316 [
[.0368 -0.0125 -6 -9 ]
[.0368 -0.0125 6 0 ]
[.2684 -0.0125 -6 -9 ]
[.2684 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7316 -0.0125 -3 -9 ]
[.7316 -0.0125 3 0 ]
[.9632 -0.0125 -3 -9 ]
[.9632 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .0368 -12 -4.5 ]
[-0.0125 .0368 0 4.5 ]
[-0.0125 .2684 -12 -4.5 ]
[-0.0125 .2684 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7316 -6 -4.5 ]
[-0.0125 .7316 0 4.5 ]
[-0.0125 .9632 -6 -4.5 ]
[-0.0125 .9632 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0368 0 m
.0368 .00625 L
s
[(-2)] .0368 -0.0125 0 1 Mshowa
.2684 0 m
.2684 .00625 L
s
[(-1)] .2684 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7316 0 m
.7316 .00625 L
s
[(1)] .7316 -0.0125 0 1 Mshowa
.9632 0 m
.9632 .00625 L
s
[(2)] .9632 -0.0125 0 1 Mshowa
.125 Mabswid
.08312 0 m
.08312 .00375 L
s
.12944 0 m
.12944 .00375 L
s
.17576 0 m
.17576 .00375 L
s
.22208 0 m
.22208 .00375 L
s
.31472 0 m
.31472 .00375 L
s
.36104 0 m
.36104 .00375 L
s
.40736 0 m
.40736 .00375 L
s
.45368 0 m
.45368 .00375 L
s
.54632 0 m
.54632 .00375 L
s
.59264 0 m
.59264 .00375 L
s
.63896 0 m
.63896 .00375 L
s
.68528 0 m
.68528 .00375 L
s
.77792 0 m
.77792 .00375 L
s
.82424 0 m
.82424 .00375 L
s
.87056 0 m
.87056 .00375 L
s
.91688 0 m
.91688 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .0368 m
.00625 .0368 L
s
[(-2)] -0.0125 .0368 1 0 Mshowa
0 .2684 m
.00625 .2684 L
s
[(-1)] -0.0125 .2684 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .7316 m
.00625 .7316 L
s
[(1)] -0.0125 .7316 1 0 Mshowa
0 .9632 m
.00625 .9632 L
s
[(2)] -0.0125 .9632 1 0 Mshowa
.125 Mabswid
0 .08312 m
.00375 .08312 L
s
0 .12944 m
.00375 .12944 L
s
0 .17576 m
.00375 .17576 L
s
0 .22208 m
.00375 .22208 L
s
0 .31472 m
.00375 .31472 L
s
0 .36104 m
.00375 .36104 L
s
0 .40736 m
.00375 .40736 L
s
0 .45368 m
.00375 .45368 L
s
0 .54632 m
.00375 .54632 L
s
0 .59264 m
.00375 .59264 L
s
0 .63896 m
.00375 .63896 L
s
0 .68528 m
.00375 .68528 L
s
0 .77792 m
.00375 .77792 L
s
0 .82424 m
.00375 .82424 L
s
0 .87056 m
.00375 .87056 L
s
0 .91688 m
.00375 .91688 L
s
.25 Mabswid
0 0 m
0 1 L
s
.0368 .99375 m
.0368 1 L
s
.2684 .99375 m
.2684 1 L
s
.5 .99375 m
.5 1 L
s
.7316 .99375 m
.7316 1 L
s
.9632 .99375 m
.9632 1 L
s
.125 Mabswid
.08312 .99625 m
.08312 1 L
s
.12944 .99625 m
.12944 1 L
s
.17576 .99625 m
.17576 1 L
s
.22208 .99625 m
.22208 1 L
s
.31472 .99625 m
.31472 1 L
s
.36104 .99625 m
.36104 1 L
s
.40736 .99625 m
.40736 1 L
s
.45368 .99625 m
.45368 1 L
s
.54632 .99625 m
.54632 1 L
s
.59264 .99625 m
.59264 1 L
s
.63896 .99625 m
.63896 1 L
s
.68528 .99625 m
.68528 1 L
s
.77792 .99625 m
.77792 1 L
s
.82424 .99625 m
.82424 1 L
s
.87056 .99625 m
.87056 1 L
s
.91688 .99625 m
.91688 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .0368 m
1 .0368 L
s
.99375 .2684 m
1 .2684 L
s
.99375 .5 m
1 .5 L
s
.99375 .7316 m
1 .7316 L
s
.99375 .9632 m
1 .9632 L
s
.125 Mabswid
.99625 .08312 m
1 .08312 L
s
.99625 .12944 m
1 .12944 L
s
.99625 .17576 m
1 .17576 L
s
.99625 .22208 m
1 .22208 L
s
.99625 .31472 m
1 .31472 L
s
.99625 .36104 m
1 .36104 L
s
.99625 .40736 m
1 .40736 L
s
.99625 .45368 m
1 .45368 L
s
.99625 .54632 m
1 .54632 L
s
.99625 .59264 m
1 .59264 L
s
.99625 .63896 m
1 .63896 L
s
.99625 .68528 m
1 .68528 L
s
.99625 .77792 m
1 .77792 L
s
.99625 .82424 m
1 .82424 L
s
.99625 .87056 m
1 .87056 L
s
.99625 .91688 m
1 .91688 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
.0368 .0368 m
.0368 .9632 L
.9632 .9632 L
.9632 .0368 L
F
0 0 0 r
.01 w
.0368 .0368 m
.9632 .0368 L
.9632 .9632 L
.0368 .9632 L
.0368 .0368 L
s
0 g
.5 Mabswid
.0368 .5 m
.9632 .5 L
s
.5 .0368 m
.5 .9632 L
s
.01 .66 .62 r
.02754 .02754 m
.04606 .04606 L
s
.02704 .07439 m
.04657 .09185 L
s
.02649 .12136 m
.04711 .13752 L
s
.02591 .16847 m
.04769 .18305 L
s
.02535 .21572 m
.04826 .22844 L
s
.02483 .26308 m
.04877 .27372 L
s
.02441 .31047 m
.04919 .31897 L
s
.02411 .3578 m
.04949 .36428 L
s
.02392 .40494 m
.04968 .40978 L
s
.02384 .4518 m
.04977 .45556 L
s
.02381 .49831 m
.04979 .50169 L
s
.02384 .54444 m
.04977 .5482 L
s
.02392 .59022 m
.04968 .59506 L
s
.02411 .63572 m
.04949 .6422 L
s
.02441 .68103 m
.04919 .68953 L
s
.02483 .72628 m
.04877 .73692 L
s
.02535 .77156 m
.04826 .78428 L
s
.02591 .81695 m
.04769 .83153 L
s
.02649 .86248 m
.04711 .87864 L
s
.02704 .90815 m
.04657 .92561 L
s
.02754 .95394 m
.04606 .97246 L
s
.07439 .02704 m
.09185 .04657 L
s
.07386 .07386 m
.09238 .09238 L
s
.07324 .12083 m
.093 .13805 L
s
.07256 .16801 m
.09369 .18351 L
s
.07183 .21543 m
.09441 .22873 L
s
.07115 .26308 m
.09509 .27372 L
s
.07059 .31089 m
.09565 .31855 L
s
.07023 .3587 m
.09601 .36338 L
s
.07006 .40627 m
.09618 .40845 L
s
.07002 .45342 m
.09622 .45394 L
s
.07002 .50003 m
.09622 .49997 L
s
.07002 .54606 m
.09622 .54658 L
s
.07006 .59155 m
.09618 .59373 L
s
.07023 .63662 m
.09601 .6413 L
s
.07059 .68145 m
.09565 .68911 L
s
.07115 .72628 m
.09509 .73692 L
s
.07183 .77127 m
.09441 .78457 L
s
.07256 .81649 m
.09369 .83199 L
s
.07324 .86195 m
.093 .87917 L
s
.07386 .90762 m
.09238 .92614 L
s
.07439 .95343 m
.09185 .97296 L
s
.12136 .02649 m
.13752 .04711 L
s
.12083 .07324 m
.13805 .093 L
s
.12018 .12018 m
.1387 .1387 L
s
.11937 .16738 m
.13951 .18414 L
s
.11843 .21497 m
.14045 .22919 L
s
.11747 .26308 m
.14141 .27372 L
s
.1167 .31169 m
.14219 .31775 L
s
.11635 .36049 m
.14253 .36159 L
s
.11644 .40897 m
.14244 .40575 L
s
.11669 .45668 m
.14219 .45068 L
s
.11681 .50347 m
.14207 .49653 L
s
.11669 .54932 m
.14219 .54332 L
s
.11644 .59425 m
.14244 .59103 L
s
.11635 .63841 m
.14253 .63951 L
s
.1167 .68225 m
.14219 .68831 L
s
.11747 .72628 m
.14141 .73692 L
s
.11843 .77081 m
.14045 .78503 L
s
.11937 .81586 m
.13951 .83262 L
s
.12018 .8613 m
.1387 .87982 L
s
.12083 .907 m
.13805 .92676 L
s
.12136 .95289 m
.13752 .97351 L
s
.16847 .02591 m
.18305 .04769 L
s
.16801 .07256 m
.18351 .09369 L
s
.16738 .11937 m
.18414 .13951 L
s
.1665 .1665 m
.18502 .18502 L
s
.16528 .21422 m
.18624 .22994 L
s
.16379 .26308 m
.18773 .27372 L
s
.1627 .31363 m
.18882 .31581 L
s
.16327 .36499 m
.18825 .3571 L
s
.16505 .41491 m
.18647 .39981 L
s
.1665 .46294 m
.18502 .44442 L
s
.167 .50974 m
.18452 .49026 L
s
.1665 .55558 m
.18502 .53706 L
s
.16505 .60019 m
.18647 .58509 L
s
.16327 .6429 m
.18825 .63501 L
s
.1627 .68419 m
.18882 .68637 L
s
.16379 .72628 m
.18773 .73692 L
s
.16528 .77006 m
.18624 .78578 L
s
.1665 .81498 m
.18502 .8335 L
s
.16738 .86049 m
.18414 .88063 L
s
.16801 .90631 m
.18351 .92744 L
s
.16847 .95231 m
.18305 .97409 L
s
.21572 .02535 m
.22844 .04826 L
s
.21543 .07183 m
.22873 .09441 L
s
.21497 .11843 m
.22919 .14045 L
s
.21422 .16528 m
.22994 .18624 L
s
.21282 .21282 m
.23134 .23134 L
s
.21011 .26308 m
.23405 .27372 L
s
.21078 .32136 m
.23338 .30809 L
s
.21775 .37341 m
.22641 .34867 L
s
.22073 .42039 m
.22343 .39433 L
s
.22185 .46678 m
.22231 .44058 L
s
.22215 .5131 m
.22201 .4869 L
s
.22185 .55942 m
.22231 .53322 L
s
.22073 .60567 m
.22343 .57961 L
s
.21775 .65133 m
.22641 .62659 L
s
.21078 .69191 m
.23338 .67864 L
s
.21011 .72628 m
.23405 .73692 L
s
.21282 .76866 m
.23134 .78718 L
s
.21422 .81376 m
.22994 .83472 L
s
.21497 .85955 m
.22919 .88157 L
s
.21543 .90559 m
.22873 .92817 L
s
.21572 .95174 m
.22844 .97465 L
s
.26308 .02483 m
.27372 .04877 L
s
.26308 .07115 m
.27372 .09509 L
s
.26308 .11747 m
.27372 .14141 L
s
.26308 .16379 m
.27372 .18773 L
s
.26308 .21011 m
.27372 .23405 L
s
newpath
.2684 .2684 .00655 0 365.73 arc
s
.27372 .32669 m
.26308 .30275 L
s
.27372 .37301 m
.26308 .34907 L
s
.27372 .41933 m
.26308 .39539 L
s
.27372 .46565 m
.26308 .44171 L
s
.27372 .51197 m
.26308 .48803 L
s
.27372 .55829 m
.26308 .53435 L
s
.27372 .60461 m
.26308 .58067 L
s
.27372 .65093 m
.26308 .62699 L
s
.27372 .69725 m
.26308 .67331 L
s
newpath
.2684 .7316 .00655 0 365.73 arc
s
.26308 .76595 m
.27372 .78989 L
s
.26308 .81227 m
.27372 .83621 L
s
.26308 .85859 m
.27372 .88253 L
s
.26308 .90491 m
.27372 .92885 L
s
.26308 .95123 m
.27372 .97517 L
s
.31047 .02441 m
.31897 .04919 L
s
.31089 .07059 m
.31855 .09565 L
s
.31169 .1167 m
.31775 .14219 L
s
.31363 .1627 m
.31581 .18882 L
s
.32136 .21078 m
.30809 .23338 L
s
.32669 .27372 m
.30275 .26308 L
s
.32398 .32398 m
.30546 .30546 L
s
.32294 .37124 m
.3065 .35084 L
s
.32247 .41793 m
.30697 .3968 L
s
.32225 .4644 m
.30719 .44296 L
s
.32219 .51077 m
.30725 .48923 L
s
.32225 .55704 m
.30719 .5356 L
s
.32247 .6032 m
.30697 .58207 L
s
.32294 .64916 m
.3065 .62876 L
s
.32398 .69454 m
.30546 .67602 L
s
.32669 .73692 m
.30275 .72628 L
s
.32136 .76662 m
.30809 .78922 L
s
.31363 .81118 m
.31581 .8373 L
s
.31169 .85781 m
.31775 .8833 L
s
.31089 .90435 m
.31855 .92941 L
s
.31047 .95081 m
.31897 .97559 L
s
.3578 .02411 m
.36428 .04949 L
s
.3587 .07023 m
.36338 .09601 L
s
.36049 .11635 m
.36159 .14253 L
s
.36499 .16327 m
.3571 .18825 L
s
.37341 .21775 m
.34867 .22641 L
s
.37301 .27372 m
.34907 .26308 L
s
.37124 .32294 m
.35084 .3065 L
s
.3703 .3703 m
.35178 .35178 L
s
.36981 .41709 m
.35227 .39763 L
s
.36957 .46363 m
.35251 .44373 L
s
.36949 .51001 m
.35259 .48999 L
s
.36957 .55627 m
.35251 .53637 L
s
.36981 .60237 m
.35227 .58291 L
s
.3703 .64822 m
.35178 .6297 L
s
.37124 .6935 m
.35084 .67706 L
s
.37301 .73692 m
.34907 .72628 L
s
.37341 .77359 m
.34867 .78225 L
s
.36499 .81175 m
.3571 .83673 L
s
.36049 .85747 m
.36159 .88365 L
s
.3587 .90399 m
.36338 .92977 L
s
.3578 .95051 m
.36428 .97589 L
s
.40494 .02392 m
.40978 .04968 L
s
.40627 .07006 m
.40845 .09618 L
s
.40897 .11644 m
.40575 .14244 L
s
.41491 .16505 m
.39981 .18647 L
s
.42039 .22073 m
.39433 .22343 L
s
.41933 .27372 m
.39539 .26308 L
s
.41793 .32247 m
.3968 .30697 L
s
.41709 .36981 m
.39763 .35227 L
s
.41662 .41662 m
.3981 .3981 L
s
.41638 .46318 m
.39834 .44418 L
s
.41631 .50957 m
.39841 .49043 L
s
.41638 .55582 m
.39834 .53682 L
s
.41662 .6019 m
.3981 .58338 L
s
.41709 .64773 m
.39763 .63019 L
s
.41793 .69303 m
.3968 .67753 L
s
.41933 .73692 m
.39539 .72628 L
s
.42039 .77657 m
.39433 .77927 L
s
.41491 .81353 m
.39981 .83495 L
s
.40897 .85756 m
.40575 .88356 L
s
.40627 .90382 m
.40845 .92994 L
s
.40494 .95032 m
.40978 .97608 L
s
.4518 .02384 m
.45556 .04977 L
s
.45342 .07002 m
.45394 .09622 L
s
.45668 .11669 m
.45068 .14219 L
s
.46294 .1665 m
.44442 .18502 L
s
.46678 .22185 m
.44058 .22231 L
s
.46565 .27372 m
.44171 .26308 L
s
.4644 .32225 m
.44296 .30719 L
s
.46363 .36957 m
.44373 .35251 L
s
.46318 .41638 m
.44418 .39834 L
s
.46294 .46294 m
.44442 .44442 L
s
.46287 .50934 m
.44449 .49066 L
s
.46294 .55558 m
.44442 .53706 L
s
.46318 .60166 m
.44418 .58362 L
s
.46363 .64749 m
.44373 .63043 L
s
.4644 .69281 m
.44296 .67775 L
s
.46565 .73692 m
.44171 .72628 L
s
.46678 .77769 m
.44058 .77815 L
s
.46294 .81498 m
.44442 .8335 L
s
.45668 .85781 m
.45068 .88331 L
s
.45342 .90378 m
.45394 .92998 L
s
.4518 .95023 m
.45556 .97616 L
s
.49831 .02381 m
.50169 .04979 L
s
.50003 .07002 m
.49997 .09622 L
s
.50347 .11681 m
.49653 .14207 L
s
.50974 .167 m
.49026 .18452 L
s
.5131 .22215 m
.4869 .22201 L
s
.51197 .27372 m
.48803 .26308 L
s
.51077 .32219 m
.48923 .30725 L
s
.51001 .36949 m
.48999 .35259 L
s
.50957 .41631 m
.49043 .39841 L
s
.50934 .46287 m
.49066 .44449 L
s
.50926 .50926 m
.49074 .49074 L
s
.50934 .55551 m
.49066 .53713 L
s
.50957 .60159 m
.49043 .58369 L
s
.51001 .64741 m
.48999 .63051 L
s
.51077 .69275 m
.48923 .67781 L
s
.51197 .73692 m
.48803 .72628 L
s
.5131 .77799 m
.4869 .77785 L
s
.50974 .81548 m
.49026 .833 L
s
.50347 .85793 m
.49653 .88319 L
s
.50003 .90378 m
.49997 .92998 L
s
.49831 .95021 m
.50169 .97619 L
s
.54444 .02384 m
.5482 .04977 L
s
.54606 .07002 m
.54658 .09622 L
s
.54932 .11669 m
.54332 .14219 L
s
.55558 .1665 m
.53706 .18502 L
s
.55942 .22185 m
.53322 .22231 L
s
.55829 .27372 m
.53435 .26308 L
s
.55704 .32225 m
.5356 .30719 L
s
.55627 .36957 m
.53637 .35251 L
s
.55582 .41638 m
.53682 .39834 L
s
.55558 .46294 m
.53706 .44442 L
s
.55551 .50934 m
.53713 .49066 L
s
.55558 .55558 m
.53706 .53706 L
s
.55582 .60166 m
.53682 .58362 L
s
.55627 .64749 m
.53637 .63043 L
s
.55704 .69281 m
.5356 .67775 L
s
.55829 .73692 m
.53435 .72628 L
s
.55942 .77769 m
.53322 .77815 L
s
.55558 .81498 m
.53706 .8335 L
s
.54932 .85781 m
.54332 .88331 L
s
.54606 .90378 m
.54658 .92998 L
s
.54444 .95023 m
.5482 .97616 L
s
.59022 .02392 m
.59506 .04968 L
s
.59155 .07006 m
.59373 .09618 L
s
.59425 .11644 m
.59103 .14244 L
s
.60019 .16505 m
.58509 .18647 L
s
.60567 .22073 m
.57961 .22343 L
s
.60461 .27372 m
.58067 .26308 L
s
.6032 .32247 m
.58207 .30697 L
s
.60237 .36981 m
.58291 .35227 L
s
.6019 .41662 m
.58338 .3981 L
s
.60166 .46318 m
.58362 .44418 L
s
.60159 .50957 m
.58369 .49043 L
s
.60166 .55582 m
.58362 .53682 L
s
.6019 .6019 m
.58338 .58338 L
s
.60237 .64773 m
.58291 .63019 L
s
.6032 .69303 m
.58207 .67753 L
s
.60461 .73692 m
.58067 .72628 L
s
.60567 .77657 m
.57961 .77927 L
s
.60019 .81353 m
.58509 .83495 L
s
.59425 .85756 m
.59103 .88356 L
s
.59155 .90382 m
.59373 .92994 L
s
.59022 .95032 m
.59506 .97608 L
s
.63572 .02411 m
.6422 .04949 L
s
.63662 .07023 m
.6413 .09601 L
s
.63841 .11635 m
.63951 .14253 L
s
.6429 .16327 m
.63501 .18825 L
s
.65133 .21775 m
.62659 .22641 L
s
.65093 .27372 m
.62699 .26308 L
s
.64916 .32294 m
.62876 .3065 L
s
.64822 .3703 m
.6297 .35178 L
s
.64773 .41709 m
.63019 .39763 L
s
.64749 .46363 m
.63043 .44373 L
s
.64741 .51001 m
.63051 .48999 L
s
.64749 .55627 m
.63043 .53637 L
s
.64773 .60237 m
.63019 .58291 L
s
.64822 .64822 m
.6297 .6297 L
s
.64916 .6935 m
.62876 .67706 L
s
.65093 .73692 m
.62699 .72628 L
s
.65133 .77359 m
.62659 .78225 L
s
.6429 .81175 m
.63501 .83673 L
s
.63841 .85747 m
.63951 .88365 L
s
.63662 .90399 m
.6413 .92977 L
s
.63572 .95051 m
.6422 .97589 L
s
.68103 .02441 m
.68953 .04919 L
s
.68145 .07059 m
.68911 .09565 L
s
.68225 .1167 m
.68831 .14219 L
s
.68419 .1627 m
.68637 .18882 L
s
.69191 .21078 m
.67864 .23338 L
s
.69725 .27372 m
.67331 .26308 L
s
.69454 .32398 m
.67602 .30546 L
s
.6935 .37124 m
.67706 .35084 L
s
.69303 .41793 m
.67753 .3968 L
s
.69281 .4644 m
.67775 .44296 L
s
.69275 .51077 m
.67781 .48923 L
s
.69281 .55704 m
.67775 .5356 L
s
.69303 .6032 m
.67753 .58207 L
s
.6935 .64916 m
.67706 .62876 L
s
.69454 .69454 m
.67602 .67602 L
s
.69725 .73692 m
.67331 .72628 L
s
.69191 .76662 m
.67864 .78922 L
s
.68419 .81118 m
.68637 .8373 L
s
.68225 .85781 m
.68831 .8833 L
s
.68145 .90435 m
.68911 .92941 L
s
.68103 .95081 m
.68953 .97559 L
s
.72628 .02483 m
.73692 .04877 L
s
.72628 .07115 m
.73692 .09509 L
s
.72628 .11747 m
.73692 .14141 L
s
.72628 .16379 m
.73692 .18773 L
s
.72628 .21011 m
.73692 .23405 L
s
newpath
.7316 .2684 .00655 0 365.73 arc
s
.73692 .32669 m
.72628 .30275 L
s
.73692 .37301 m
.72628 .34907 L
s
.73692 .41933 m
.72628 .39539 L
s
.73692 .46565 m
.72628 .44171 L
s
.73692 .51197 m
.72628 .48803 L
s
.73692 .55829 m
.72628 .53435 L
s
.73692 .60461 m
.72628 .58067 L
s
.73692 .65093 m
.72628 .62699 L
s
.73692 .69725 m
.72628 .67331 L
s
newpath
.7316 .7316 .00655 0 365.73 arc
s
.72628 .76595 m
.73692 .78989 L
s
.72628 .81227 m
.73692 .83621 L
s
.72628 .85859 m
.73692 .88253 L
s
.72628 .90491 m
.73692 .92885 L
s
.72628 .95123 m
.73692 .97517 L
s
.77156 .02535 m
.78428 .04826 L
s
.77127 .07183 m
.78457 .09441 L
s
.77081 .11843 m
.78503 .14045 L
s
.77006 .16528 m
.78578 .18624 L
s
.76866 .21282 m
.78718 .23134 L
s
.76595 .26308 m
.78989 .27372 L
s
.76662 .32136 m
.78922 .30809 L
s
.77359 .37341 m
.78225 .34867 L
s
.77657 .42039 m
.77927 .39433 L
s
.77769 .46678 m
.77815 .44058 L
s
.77799 .5131 m
.77785 .4869 L
s
.77769 .55942 m
.77815 .53322 L
s
.77657 .60567 m
.77927 .57961 L
s
.77359 .65133 m
.78225 .62659 L
s
.76662 .69191 m
.78922 .67864 L
s
.76595 .72628 m
.78989 .73692 L
s
.76866 .76866 m
.78718 .78718 L
s
.77006 .81376 m
.78578 .83472 L
s
.77081 .85955 m
.78503 .88157 L
s
.77127 .90559 m
.78457 .92817 L
s
.77156 .95174 m
.78428 .97465 L
s
.81695 .02591 m
.83153 .04769 L
s
.81649 .07256 m
.83199 .09369 L
s
.81586 .11937 m
.83262 .13951 L
s
.81498 .1665 m
.8335 .18502 L
s
.81376 .21422 m
.83472 .22994 L
s
.81227 .26308 m
.83621 .27372 L
s
.81118 .31363 m
.8373 .31581 L
s
.81175 .36499 m
.83673 .3571 L
s
.81353 .41491 m
.83495 .39981 L
s
.81498 .46294 m
.8335 .44442 L
s
.81548 .50974 m
.833 .49026 L
s
.81498 .55558 m
.8335 .53706 L
s
.81353 .60019 m
.83495 .58509 L
s
.81175 .6429 m
.83673 .63501 L
s
.81118 .68419 m
.8373 .68637 L
s
.81227 .72628 m
.83621 .73692 L
s
.81376 .77006 m
.83472 .78578 L
s
.81498 .81498 m
.8335 .8335 L
s
.81586 .86049 m
.83262 .88063 L
s
.81649 .90631 m
.83199 .92744 L
s
.81695 .95231 m
.83153 .97409 L
s
.86248 .02649 m
.87864 .04711 L
s
.86195 .07324 m
.87917 .093 L
s
.8613 .12018 m
.87982 .1387 L
s
.86049 .16738 m
.88063 .18414 L
s
.85955 .21497 m
.88157 .22919 L
s
.85859 .26308 m
.88253 .27372 L
s
.85781 .31169 m
.8833 .31775 L
s
.85747 .36049 m
.88365 .36159 L
s
.85756 .40897 m
.88356 .40575 L
s
.85781 .45668 m
.88331 .45068 L
s
.85793 .50347 m
.88319 .49653 L
s
.85781 .54932 m
.88331 .54332 L
s
.85756 .59425 m
.88356 .59103 L
s
.85747 .63841 m
.88365 .63951 L
s
.85781 .68225 m
.8833 .68831 L
s
.85859 .72628 m
.88253 .73692 L
s
.85955 .77081 m
.88157 .78503 L
s
.86049 .81586 m
.88063 .83262 L
s
.8613 .8613 m
.87982 .87982 L
s
.86195 .907 m
.87917 .92676 L
s
.86248 .95289 m
.87864 .97351 L
s
.90815 .02704 m
.92561 .04657 L
s
.90762 .07386 m
.92614 .09238 L
s
.907 .12083 m
.92676 .13805 L
s
.90631 .16801 m
.92744 .18351 L
s
.90559 .21543 m
.92817 .22873 L
s
.90491 .26308 m
.92885 .27372 L
s
.90435 .31089 m
.92941 .31855 L
s
.90399 .3587 m
.92977 .36338 L
s
.90382 .40627 m
.92994 .40845 L
s
.90378 .45342 m
.92998 .45394 L
s
.90378 .50003 m
.92998 .49997 L
s
.90378 .54606 m
.92998 .54658 L
s
.90382 .59155 m
.92994 .59373 L
s
.90399 .63662 m
.92977 .6413 L
s
.90435 .68145 m
.92941 .68911 L
s
.90491 .72628 m
.92885 .73692 L
s
.90559 .77127 m
.92817 .78457 L
s
.90631 .81649 m
.92744 .83199 L
s
.907 .86195 m
.92676 .87917 L
s
.90762 .90762 m
.92614 .92614 L
s
.90815 .95343 m
.92561 .97296 L
s
.95394 .02754 m
.97246 .04606 L
s
.95343 .07439 m
.97296 .09185 L
s
.95289 .12136 m
.97351 .13752 L
s
.95231 .16847 m
.97409 .18305 L
s
.95174 .21572 m
.97465 .22844 L
s
.95123 .26308 m
.97517 .27372 L
s
.95081 .31047 m
.97559 .31897 L
s
.95051 .3578 m
.97589 .36428 L
s
.95032 .40494 m
.97608 .40978 L
s
.95023 .4518 m
.97616 .45556 L
s
.95021 .49831 m
.97619 .50169 L
s
.95023 .54444 m
.97616 .5482 L
s
.95032 .59022 m
.97608 .59506 L
s
.95051 .63572 m
.97589 .6422 L
s
.95081 .68103 m
.97559 .68953 L
s
.95123 .72628 m
.97517 .73692 L
s
.95174 .77156 m
.97465 .78428 L
s
.95231 .81695 m
.97409 .83153 L
s
.95289 .86248 m
.97351 .87864 L
s
.95343 .90815 m
.97296 .92561 L
s
.95394 .95394 m
.97246 .97246 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`006Oooool5o`0003_ooooo0ol0000jooooo`;o0000
??ooool3o`0003[ooooo1Ol0000:ooooo`006_ooool01?l0003oooooooooool0000looooo`03o`00
0?oooooooooo03Sooooo00Co0000oooooooooooo0000??ooool00ol0003oooooooooo`0jooooo`04
o`000?ooooooooooo`0000[ooooo000Cooooo`Go00000oooool00ol0003oooooooooo`0dooooo`Go
00000oooool00ol0003oooooooooo`0hooooo`04o`000?ooooooooooo`0003cooooo00?o0000oooo
ooooool0>oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`0kooooo`03
o`000?oooooooooo03Sooooo00Co0000oooooooooooo0000??ooool00ol0003oooooooooo`0loooo
o`03o`000?oooooooooo00Wooooo000Iooooo`05o`000?ooooooooooooooool00000??ooool00ol0
003oooooooooo`0hooooo`04o`000?ooooooooooo`0003cooooo00?o0000ooooooooool0>Oooool0
1Ol0003ooooooooooooooooo000000[ooooo000Iooooo`05o`000?ooooooooooooooool00000>ooo
ool2o`0003[ooooo00Co0000oooooooooooo0000>oooool2o`0003_ooooo00Go0000oooooooooooo
ooooo`00000:ooooo`006_ooool3o`0003gooooo00?o0000ooooooooool0>Oooool2o`0003gooooo
00?o0000ooooooooool0>_ooool3o`0000_ooooo003oooooob7ooooo003oooooob7ooooo003ooooo
ob7ooooo003oooooob7ooooo000?oooooooo00004Ol00001ooooo`003oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0l
ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0k
ooooo`03o`000?oooooooooo00Oooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`3ooooo
o`gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`3oooooo`gooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`3oooooo`gooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`3oooooo`gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`0[ooooo`03o`:XW_oooooo
oooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooo
oooo00[ooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooo
oooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooo
oooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooo
oooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0^ooooo`7o00000Oooool0
00Kooooo1Ol00004ooooo`03o`000?oooooooooo00Cooooo00?o0ZRNooooooooool02_ooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo0Ol00001ooooo`001oooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNooooooooool02_ooool00ol2
Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00_ooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Sooooo00?o0ZRNooooooooool02_ooool00ol2
Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Sooooo0Ol00001ooooo`001Ol00003ooooo`03
o`000?oooooooooo00Cooooo0ol00006ooooo`03o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002Ol000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o000000So000000?o0ZRNo`000?l0
00002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l0
00002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l0
00002ol000000ol2Z9ko0000o`000008o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002_l000000ol2Z9koooooooooo`06ooooo`;o00000Oooool000Wooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`06ooooo`03o`000?l2Z9ko000000_o000000?o0ZRNo`000?l00000
2Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l00000
2_l000000ol2Z9koooooooooo`06ooooo`7o00000Oooool000Kooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo00Kooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Ooc>KI0_l000000ooooooo0ZRNooooo`06ooooo`7o00000Oooool000Kooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Kooooo0_l000000oo<i]Wo0ZRN
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00002ooooo`03o`:XW_oooooooooo00Cooooo
0Ol00001ooooo`001oooool3o`0000Gooooo00?o0000ooooooooool01_ooool2o`0003?oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T0;?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<
i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001SolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0HOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o00005_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI01Ooc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01?ooool2o`:XWP;o00002Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@;o0ZRN00?o0000ooooooooool01oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo00?o0ZRNo`000?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?l2Z9kooooo00So
oooo0Ol00001ooooo`003oooool2o`0000Oooooo00?o0000o`:XW_l2Z9h02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@;o000000?o0ZRNooooooooool01Oooool2o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l0
00000ooooooo0ZRNooooo`06ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0000;oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@;o00000_ooool0
0ol2Z9koooooooooo`04ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
00koc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000F?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@1ColcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI
0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o
0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003coc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0lolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Cooooo0_l2Z9h2o`0000Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000
o`000009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool00ol2Z9ko0000olcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool02?ooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`003oooool2o`0000Oooooo0_l000000ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`05oooo
o`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`000003olcVfOl2Z9koc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003ooooool2Z9kooooo00Kooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o00000_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_l0003oc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Koc>KI0_l00002ooooo`03o`:XW_oooooooooo00Cooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000<oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000olcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0/olcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Wo
c>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
07goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI
0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o
0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000;oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI01Coc>KI00?o0000
olcVfOo<i]T06?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI033oc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01?ooool2o`:XWP;o00002Oo<i]T2o`:X
WP[oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0000olcVfOl2Z9h03?o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@;o0ZRN2_o<i]T2o`:XWP[oc>KI0_l2Z9h2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_o<
i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Oooool000oooooo0_l00007ooooo`03o`00
0?l2Z9ko0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T2o`:XWPWoc>KI00?o0000o`:XW_l2Z9h01oooool2o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003oc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l0
00000ooooooo0ZRNooooo`06ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0000;oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIo`00000:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@;o00000_ooool0
0ol2Z9koooooooooo`04ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
02Ooc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01?l2Z9koc>KIolcVfOl00009olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI01ooc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
04_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0TolcVf@03o`000?o<i]Woc>KI
027oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@17olcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003coc>KI00?o0ZRNolcV
fOo<i]T0?_o<i]T00ol0003oc>KIolcVf@0jolcVf@03o`:XW_o<i]Woc>KI03coc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0002ooc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0=olcVf@03o`:XW_o<i]Woc>KI02koc>KI00?o0000olcVfOo<
i]T0<Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T0<?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`;o0ZRN
0_l00008olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0^olcVf@03o`000?o<i]Woc>KI037oc>KI
00?o0ZRNolcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0ZRN2_o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@;o0ZRN2Oo<i]T4o`:XWQGoc>KI00?o0000olcVfOo<i]T05_o<
i]T4o`:XWP[oc>KI0ol2Z9h9olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2Oooool1o`00007ooooo000?ooooo`;o00001oooool2
o`0000;o0ZRN2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08
olcVf@?o0ZRN1oo<i]T4o`:XWPWoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI1?l2Z9h;
olcVf@?o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2Oo<i]T2o`0000;o0ZRN1_ooool2
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`:X
WROoc>KI00?o0000olcVfOo<i]T07oo<i]T2o`:XWPkoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00002ooooo`03o`:XW_oooooooooo
00Cooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o00003oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0<?o<i]T00ol0003o
c>KIolcVf@0^olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@05olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0000oolcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T0<Oo<i]T00ol0003oc>KI
olcVf@0]olcVf@03o`:XW_o<i]Woc>KI00goc>KI00?o0ZRNolcVfOo<i]T0>Oo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`001oooool3
o`0000Gooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`002?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Cooooo0_l2Z9h2o`0000Soc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h=olcV
f@?o0ZRN1oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h2olcV
f@03o`000?o<i]Woc>KI00Koc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h<olcV
f@Co0ZRN1oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h2o`00
00Wooooo0Ol00001ooooo`001Ol00003ooooo`03o`000?oooooooooo00Cooooo0ol00006ooooo`;o
0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI00Go0ZRNolcVfOo<
i]Woc>KIo`:XWP08olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@;o0ZRN2_o<i]T3o`:X
WP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h:olcVf@04o`:XW_o<i]Woc>KI
o`:XWPWoc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@?o0ZRN1oooool2
o`00007ooooo0008ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01_ooool2o`00
00;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWPSoc>KI00Go0ZRNolcV
fOo<i]Woc>KIo`:XWP0;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T0
0ol0003o0ZRNo`:XWP0:olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2?o<i]T0
1?l2Z9koc>KIolcVfOl2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2?o<
i]T2o`000003ooooool2Z9ko0ZRN00Kooooo0Ol00001ooooo`002?ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T01Oo<i]T4o`:XWPkoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?l0003oc>KIolcVfOl2
Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Goc>KI1?l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI0_l0
0003ooooo`03o`:XW_oooooooooo00?ooooo0Ol00001ooooo`001oooool2o`0000Kooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`002?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Kooooo0_l0001molcV
f@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000lolcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T0<_o<i]T00ol0003oc>KIolcVf@0/olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T0??o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000<oo<i]T2o`:XWPOoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@08olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN00?oc>KIo`000?o<i]T0
1oo<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00goc>KI0_l2Z9h]olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Cooooo0ol2Z9h00ol0003oc>KIolcVf@06olcVf@?o0ZRN2_o<i]T3o`:XWQ[oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNo`000?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T04_o<i]T3o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN00?o0000ooooooooool01ooo
ool1o`00007ooooo000?ooooo`;o00001oooool01?l0003o0ZRNo`:XW_l2Z9h9olcVf@?o0ZRN2_o<
i]T3o`:XWPKoc>KI2?l2Z9h7olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN2_o<
i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2?o<i]T8o`:XWPSoc>KI0ol2Z9h9olcVf@?o0ZRN2Oo<
i]T01?l0003o0ZRNo`:XW_l2Z9h6ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T04Oo<
i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol0003oc>KIo`:XWP0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<
i]T00ol2Z9koc>KIolcVf@0KolcVf@;o0ZRN2_o<i]T2o`:XWPOoc>KI0_l00002ooooo`;o0ZRN1Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000^olcVf@03o`:XW_o<i]Wo
c>KI00goc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04o`000?o<i]Wo
c>KIo`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@06olcVf@03o`:XW_o<
i]Woc>KI037oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0003ooc>KI00?o0ZRNolcVfOo<i]T0>oo<i]T00ol0003oc>KIolcVf@0molcVf@03o`:XW_o<i]Wo
c>KI03Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
07goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI
0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o
0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l0000bolcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcV
fOo<i]T0?_o<i]T00ol0003oc>KIolcVf@0jolcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcV
fOo<i]T0;Oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000<_o<i]T00ol2Z9koc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@04
o`:XW_o<i]Woc>KIo`0000Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0<olcV
f@03o`:XW_o<i]Woc>KI02goc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`0002Ooc>KI0_l2Z9h9olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo000000[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9hPolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`;o00001?ooool5o`:XWPSoc>KI1Ol2Z9h7olcVf@Go0ZRN
2oo<i]T3o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T3o`:XWPOoc>KI1Ol2Z9h7olcVf@Go0ZRN
2?o<i]T5o`:XWPOooooo0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o00000ol2
Z9h:olcVf@?o0ZRN2Oo<i]T4o`:XWPGoc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l2
Z9h?olcVf@?o0ZRN2Oo<i]T3o`:XWPOoc>KI0_l000001?oooooo0ZRNo`:XW_l2Z9h5ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`00027oc>KI00?o0ZRNolcVfOo<i]T03Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI02Goc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`00033oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0000olcVfOl2Z9h03?o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0;oo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000<?o<i]T00ol2
Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI03_oc>KI00?o0000olcVfOo<i]T0?Oo<i]T00ol2
Z9koc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI02ooc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000bolcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI02Goc>KI00?o0000olcVfOo<i]T08?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0^olcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000WolcVf@;o0ZRN
2Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN
00?oc>KIo`000?o<i]T02?o<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0<olcVf@;o0ZRN8?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`03ooooo`?o0ZRN0_l0000VolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?o<i]T02_o<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0NolcVf@?o0ZRN00?o0000ooooooooool01oooool1o`00007ooooo000?
ooooo`;o00001oooool3o`:XWPOoc>KI2?l2Z9h5olcVf@So0ZRN1oo<i]T2o`:XWPcoc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@;o0ZRN2?o<i]T8o`:XWPCoc>KI2?l2Z9h7olcVf@04o`000?l2Z9ko0ZRNo`:XWPKooooo0_l0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_l2Z9h08?o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T08oo<i]T2
o`0000;ooooo0_l2Z9h5ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
02;oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol0003oc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI
02Coc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00037o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0DolcVf@03o`000?o<i]Woc>KI01So
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0^olcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000aolcVf@03o`:XW_o<i]Woc>KI04Woc>KI
00?o0000olcVfOo<i]T0B?o<i]T00ol2Z9koc>KIolcVf@0^olcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00037oc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol2Z9koc>KIolcVf@0nolcVf@03o`000?o<i]Woc>KI03[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0^olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0000WolcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00Co0ZRNolcVfOo<i]Wo0000
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
3?o<i]T00ol2Z9koc>KIolcVf@0OolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0000VolcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOl000002_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0PolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00?ooooo1Ol2Z9hHolcVf@Co0ZRN2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003o
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T4o`:XWQ7oc>KI1Ol2Z9h8ooooo`7o00000Oooool0
00oooooo0_l00007ooooo`;o00000ol2Z9h5olcVf@So0ZRN1Oo<i]T3o`:XWPcoc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI1?l2Z9h8olcV
f@So0ZRN1oo<i]T2o`000004ooooool2Z9ko0ZRNo`:XWPCooooo0_l00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o00008oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9koc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?o0ZRNolcVfOo<i]T08oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o00008_o<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@03o`000?o<i]Wo0ZRN00co
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Oo
c>KI00?o0ZRNolcVfOo<i]T09?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000<Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T0;_o<i]T00ol0003oc>KIolcVf@0aolcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0^olcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000<Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0UolcVf@03o`000?o<i]Woc>KI023oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0;_o<
i]T2o`0000Wooooo0Ol00001ooooo`002?ooool2o`0000Gooooo00?o0000ooooooooool01_ooool2
o`0002Ooc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01?l2Z9koc>KIolcVfOl00009olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<
i]Woc>KI01ooc>KI0_l00009ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00001?oo
ool00ol0003oooooooooo`06ooooo`;o00006_o<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIo`00000:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0ol2Z9hColcVf@;o00002Ooo
ool1o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo0ol00003ooooo`Go0ZRN2?l0
0008o`:XWPOo00000ol2Z9h;o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002Ol0
00000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol0
00000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l0
00000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002_l0
00000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002_l0
00000ol2Z9ko0000o`000008o`0000?o0ZRN1ol00008o`:XWPGo00001Ol2Z9h7ooooo`;o00000Ooo
ool000Oooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`06ooooo`;o00000ol2
Z9hBolcVf@;o0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T01oo<i]T2o`:XWQWoc>KI0_l000001?oooooo0ZRNo`:XW_l2Z9h5ooooo`7o0000
0Oooool000Oooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`06ooooo`;o0000
8oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
8oo<i]T2o`0000Wooooo0Ol00001ooooo`001oooool01?l0003oooooooooool00004ooooo`03o`00
0?oooooooooo00Kooooo0_l0000RolcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0000olcVfOl2Z9h0
3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T00ol2Z9koc>KIolcVf@0TolcVf@;o00002Oooool1o`00007ooooo0008ooooo`;o00001Ooo
ool00ol0003oooooooooo`06ooooo`;o0000<Oo<i]T00ol2Z9koc>KIolcVf@19olcVf@03o`000?o<
i]Woc>KI04Soc>KI00?o0ZRNolcVfOo<i]T0;_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0000aolcVf@03o`:XW_o<i]Woc>KI04Woc>KI00?o
0000olcVfOo<i]T0B?o<i]T00ol2Z9koc>KIolcVf@0^olcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0000WolcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00Co0ZRN
olcVfOo<i]Wo00002Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0OolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0000VolcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOl000002_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0PolcVf@;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00?ooooo1Ol2Z9hJolcVf@;o0ZRN2Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T3o`:XWQ7oc>KI1Ol2Z9h8oooo
o`7o00000Oooool000oooooo0_l00007ooooo`;o00000ol2Z9h5olcVf@So0ZRN1oo<i]T3o`:XWP[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI0ol2Z9h7olcVf@So0ZRN1oo<i]T2o`000004ooooool2Z9ko0ZRNo`:XWPCooooo0_l00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o00005Oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9hIolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000RolcVf@03o`:X
W_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Ooc>KI00?o0000olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@0TolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000aolcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0^olcVf@03o`000?o<
i]Woc>KI037oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<
i]Woc>KI02koc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0000bolcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0bolcVf@03o`000?o<i]Woc>KI02goc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI02koc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0002Ooc>KI0_l2Z9h9olcV
f@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI00Co0ZRNolcV
fOo<i]Wo00002Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T03?o<i]T2o`:XWR3oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0002Koc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIo`00000:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI023oc>KI0_l00009ooooo`7o00000Oooool000oooooo0_l00004ooooo`Go
0ZRN2?o<i]T5o`:XWPcoc>KI1?l2Z9h7olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko0000olcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o
0ZRN3?o<i]T4o`:XWPCoc>KI1Ol2Z9h8olcVf@Go0ZRN1oooool2o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l00003o`:XWP[oc>KI0ol2Z9h5olcVf@Co0ZRN2_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02?o<i]T4o`:XWPgoc>KI
0ol2Z9h7olcVf@;o000000Coooooo`:XW_l2Z9ko0ZRN1Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0000RolcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_o<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T00ol2Z9koc>KIolcVf@0TolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0000aolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@07olcVf@03o`000?o<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI02koc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`00037oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0kolcVf@03o`000?o<i]Woc>KI03goc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@0^olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000<_o<i]T00ol2Z9koc>KIolcVf@07olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0VolcV
f@03o`000?o<i]Woc>KI023oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T0;Oo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000<_o<i]T00ol2Z9koc>KIolcVf@07olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o
0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h00oo<i]Wo0000olcVf@08olcVf@;o0ZRN2_o<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00co
c>KI00?o0ZRNolcVfOo<i]T0;Oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`03ooooo`?o0ZRN0_l00008olcVf@?o0ZRN6oo<i]T3o`:XWPSoc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?o<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T3o`:XWQ7oc>KI0ol2Z9h:olcVf@?o0ZRN00?o0000ooooooooool01oooool1o`00007ooooo
000?ooooo`;o00001oooool3o`:XWP[oc>KI0ol2Z9h6olcVf@Wo0ZRN1_o<i]T3o`:XWP_oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@08olcVf@?o0ZRN2?o<i]T8o`:XWPOoc>KI0ol2Z9h9olcVf@04o`000?l2Z9ko0ZRNo`:XWPKooooo
0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_l2Z9h02oo<
i]T2o`:XWQ7oc>KI0_l2Z9h>olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l2Z9hMolcVf@;o0ZRN1oo<
i]T2o`0000;ooooo0_l2Z9h5ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`00033oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00?o0000olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI00?o0ZRNolcVfOo<i]T0;oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000<?o<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T0;Oo<i]T00ol0003oc>KIolcVf@0aolcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@0_olcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000??o<i]T00ol2Z9koc>KIolcVf@0nolcVf@03o`000?o<i]Woc>KI03[oc>KI00?o0ZRNolcVfOo<
i]T0??o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
??o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN00?oc>KIo`000?o<i]T01oo<i]T2o`:XWP_oc>KI
0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0lolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Cooooo0_l2
Z9h2o`0000Soc>KI0_l2Z9hYolcVf@;o0ZRN2?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNo`000?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00coc>KI0_l2Z9hNolcVf@;o0ZRN2oo<i]T2o`:XWP;o00002Oooool1o`00007ooooo000?
ooooo`;o00001oooool2o`:XWP[oc>KI0ol2Z9h8olcVf@Co0ZRN2?o<i]T5o`:XWP_oc>KI0_l2Z9h:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPOoc>KI1Ol2Z9h8
olcVf@Go0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h7ooooo`;o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0000;o0ZRN2oo<i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN1_o<i]T2o`:X
WPgoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9koc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@;o0ZRN3_o<i]T3o`:X
WP[oc>KI0ol2Z9h9olcVf@;o0ZRN2?o<i]T2o`000003ooooool2Z9ko0ZRN00Kooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o00000_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI01coc>KI00?o0ZRNolcVfOo<i]T03Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI00?o0000olcVfOl2Z9h02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T0:Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@;o
00000oooool00ol2Z9koooooooooo`03ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0003koc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04o`00
0?o<i]Woc>KIo`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0jolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000oolcVf@03o`:X
W_o<i]Woc>KI03_oc>KI00?o0000olcVfOo<i]T0?Oo<i]T00ol2Z9koc>KIolcVf@0iolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo0007
ooooo`?o00001Oooool00ol0003oooooooooo`06ooooo`;o0000?_o<i]T00ol2Z9koc>KIolcVf@0l
olcVf@03o`000?o<i]Woc>KI03_oc>KI0_l2Z9hlolcVf@;o00002Oooool1o`00007ooooo0008oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool2o`:XWP;o00002?o<i]T2o`:X
WP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWPgoc>KI00?o0ZRNolcVfOl2Z9h01oo<i]T2o`:X
WP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h2olcVf@03o`000?o<i]Woc>KI
00Koc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@04o`:XW_o<i]Woc>KI
o`:XWPOoc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN0_l00009
ooooo`7o00000Oooool000Sooooo00?o0000ooooooooool01?ooool3o`0000Kooooo0_l2Z9h:olcV
f@?o0ZRN2_o<i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@;o0ZRN2_o<i]T01Ol2Z9koc>KIolcVfOo<i]Wo
0ZRN00Soc>KI0ol2Z9h:olcVf@;o0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T2
o`:XWP_oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI00Co0ZRNolcVfOo<i]Wo0ZRN2Oo<
i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0ol2Z9h7ooooo`;o00000Ooo
ool000Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06ooooo`;o00000_l2Z9h;
olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2?o<i]T2o`:XWP03olcVfOl2Z9ko
c>KI00_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h:olcVf@03o`000?l2Z9ko
0ZRN00[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h8olcVf@04o`:XW_o<i]Wo
0ZRNo`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h8olcVf@;o000000?o
ooooo`:XW_l2Z9h01_ooool1o`00007ooooo0008ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01_ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@07
olcVf@03o`:XW_o<i]Woc>KI00goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?l0003oc>KIolcVfOl2
Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T03Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@05olcVf@;o00000oooool00ol2Z9koooooooooo`03ooooo`7o00000Oooool000Oooooo0_l00006
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0003coc>KI00?o0ZRNolcVfOo<i]T0?_o<i]T00ol0
003oc>KIolcVf@0jolcVf@03o`:XW_o<i]Woc>KI03coc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0002ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0=olcVf@03o`:XW_o<i]Woc>KI02koc>KI00?o0000olcVfOo<i]T0<Oo<i]T00ol2Z9ko
c>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0<?o<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`;o0ZRN0_l00008olcVf@;o0ZRN
2oo<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN8_o<i]T00ol0003oc>KIolcVf@0UolcVf@;o0ZRN
2_o<i]T00ol2Z9koc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l2Z9h:olcVf@?o0ZRN2_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@Co0ZRN5Oo<i]T00ol0003oc>KIolcV
f@0FolcVf@Co0ZRN2?o<i]T3o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@;o0ZRN2_o<i]T2o`:XWPWooooo0Ol00001ooooo`003oooool2o`0000Oooooo0_l00002
o`:XWP_oc>KI0_l2Z9h9olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@;o0ZRN2Oo<i]T4
o`:XWPWoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI1?l2Z9h:olcVf@;o0ZRN3Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2
o`:XWP[oc>KI0_l2Z9h<olcVf@;o0ZRN2?o<i]T2o`0000;o0ZRN1_ooool2o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcV
fOo<i]T09_o<i]T00ol0003oc>KIolcVf@0OolcVf@03o`:XW_o<i]Woc>KI00goc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Goc>KI0_l00002oooo
o`03o`:XW_oooooooooo00Cooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
00006oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI033oc>KI00?o0000olcVfOo<
i]T0;_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI01;oc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003ooc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T00ol2Z9koc>KIolcVf@0aolcVf@03o`000?o<i]Woc>KI02goc>KI00?o0ZRNolcVfOo<i]T0
3Oo<i]T00ol2Z9koc>KIolcVf@0iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0
003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000;oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI01Coc>KI00?o0000olcVfOo<i]T06?o<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI033oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01?ooool2o`:XWP;o00002Oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00?o0000olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2_o<i]T2
o`:XWP[oc>KI0_l2Z9h2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko0000ooooo`08oooo
o`7o00000Oooool000oooooo0_l00007ooooo`03o`000?l2Z9ko0ZRN00_oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPWoc>KI00?o0000o`:XW_l2
Z9h01oooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l000000oo<i]Wo0ZRN
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l000000ooooooo0ZRNooooo`06ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIo`00000:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@05olcVf@;o00000_ooool00ol2Z9koooooooooo`04ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0002Ooc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
1?l2Z9koc>KIolcVfOl00009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI01ooc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0004_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@0TolcVf@03o`000?o<i]Woc>KI027oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@17olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0004[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI04Soc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0000Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`04ooooo`;o0ZRN0_l0000:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9koc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI0_l2Z9h00ol0003oooooooooo`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool00ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_ooool0
2?ooool1o`00007ooooo000?ooooo`;o00001oooool00ol0003o0ZRNo`:XWP0;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`05ooooo`;o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`000003olcVfOl2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2
o`000003ooooool2Z9kooooo00Kooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o00000_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003oc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00002oooo
o`03o`:XW_oooooooooo00Cooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
00009oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003oc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T07oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0
003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0002?oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI02?oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01?ooool2o`:XWP;o00002Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0
003o000000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`03o`:XW_l0003o
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Oooool0
00oooooo0_l00007ooooo`03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0
003o0ZRNooooo`07ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`000003
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Ko
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_o<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T01_o<i]T2o`0000;ooooo00?o0ZRNooooooooool01?ooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0000oolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T0>Oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001FolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI05Goc>KI0_l00009ooooo`7o00000Oooool0
00Kooooo1Ol00004ooooo`03o`000?oooooooooo00Cooooo00Co0ZRNooooool0003o00002Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003o000000Wooooo0Ol00001ooooo`001oooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?l000002Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_l0003ooooo00Sooooo0Ol00001ooooo`002?ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Kooooo00?o0ZRNo`000?o<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`002Oooool00ol0003o
ooooooooo`03ooooo`?o00001_ooool00ol0003o0ZRNo`00000:o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000Wo
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000_o
000000?o0ZRNooooooooool01Oooool2o`00007ooooo0006ooooo`05o`000?ooooooooooooooool0
00001?ooool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko
0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko
0000o`00000:o`000003ooooool2Z9kooooo00Kooooo0Ol00001ooooo`001_ooool01Ol0003ooooo
oooooooooooo000000Cooooo00?o0000ooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`03
o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03
o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03
o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03
o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03
o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03
o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03
o`:XW_oooooooooo00_ooooo00?o0ZRNooooooooool01?ooool1o`00007ooooo0007ooooo`?o0000
1Oooool00ol0003oooooooooo`0Fooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo017ooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`3oooooo`gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`3o
ooooo`gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`3oooooo`gooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`3oooooo`gooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0??ooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool01oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00Oooooo0Ol00001ooooo`003oooooooo`00017o00000Oooool0
0?oooooo8Oooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-2.40375, -2.38088, 0.0159047, \
0.0159047}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generate starting points for solutions", "Subsection"],

Cell[TextData[{
  "You may define the variable ",
  StyleBox["thePoints",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to be any list of one or more initial values. One point might be  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "Two",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "points might be",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}, {2, 3}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "etc. \n\nHere ",
  Cell[BoxData[
      FormBox[
        StyleBox["thePoints",
          FontWeight->"Bold"], TraditionalForm]]],
  " is the set of points on the two axes at intervals of 1. The ends of the \
axes were extended to produce more solutions. However, extending too far may \
produce anomalies in the plot (as you are likely to eventually discover)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t1 = Table[{k, \(-k\)}, {k, \(-1\), 1,  .25}]\)], "Input"],

Cell[BoxData[
    \({{\(-1\), 1}, {\(-0.75`\), 0.75`}, {\(-0.5`\), 0.5`}, {\(-0.25`\), 
        0.25`}, {0.`, 
        0.`}, {0.25`, \(-0.25`\)}, {0.5`, \(-0.5`\)}, {0.75`, \(-0.75`\)}, \
{1.`, \(-1.`\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(t2 = Table[{\(-2\), k}, {k, \(-2\), 2,  .25}]\)], "Input"],

Cell[BoxData[
    \({{\(-2\), \(-2\)}, {\(-2\), \(-1.75`\)}, {\(-2\), \(-1.5`\)}, {\(-2\), \
\(-1.25`\)}, {\(-2\), \(-1.`\)}, {\(-2\), \(-0.75`\)}, {\(-2\), \(-0.5`\)}, {\
\(-2\), \(-0.25`\)}, {\(-2\), 0.`}, {\(-2\), 0.25`}, {\(-2\), 0.5`}, {\(-2\), 
        0.75`}, {\(-2\), 1.`}, {\(-2\), 1.25`}, {\(-2\), 1.5`}, {\(-2\), 
        1.75`}, {\(-2\), 2.`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(t3 = Table[{2, k}, {k, \(-2\), 2,  .25}]\)], "Input"],

Cell[BoxData[
    \({{2, \(-2\)}, {2, \(-1.75`\)}, {2, \(-1.5`\)}, {2, \(-1.25`\)}, {2, \
\(-1.`\)}, {2, \(-0.75`\)}, {2, \(-0.5`\)}, {2, \(-0.25`\)}, {2, 0.`}, {2, 
        0.25`}, {2, 0.5`}, {2, 0.75`}, {2, 1.`}, {2, 1.25`}, {2, 1.5`}, {2, 
        1.75`}, {2, 2.`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(thePoints = Join[t1, t2, t3];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Produce Final Output (This takes a while)", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DisplayAll;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.25 0.5 0.25 [
[.125 -0.0125 -12 -9 ]
[.125 -0.0125 12 0 ]
[.25 -0.0125 -6 -9 ]
[.25 -0.0125 6 0 ]
[.375 -0.0125 -12 -9 ]
[.375 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.625 -0.0125 -9 -9 ]
[.625 -0.0125 9 0 ]
[.75 -0.0125 -3 -9 ]
[.75 -0.0125 3 0 ]
[.875 -0.0125 -9 -9 ]
[.875 -0.0125 9 0 ]
[1 -0.0125 -3 -9 ]
[1 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .125 -24 -4.5 ]
[-0.0125 .125 0 4.5 ]
[-0.0125 .25 -12 -4.5 ]
[-0.0125 .25 0 4.5 ]
[-0.0125 .375 -24 -4.5 ]
[-0.0125 .375 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .625 -18 -4.5 ]
[-0.0125 .625 0 4.5 ]
[-0.0125 .75 -6 -4.5 ]
[-0.0125 .75 0 4.5 ]
[-0.0125 .875 -18 -4.5 ]
[-0.0125 .875 0 4.5 ]
[-0.0125 1 -6 -4.5 ]
[-0.0125 1 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.125 0 m
.125 .00625 L
s
[(-1.5)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(-1)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(-0.5)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(0.5)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(1)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(1.5)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(2)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .125 m
.00625 .125 L
s
[(-1.5)] -0.0125 .125 1 0 Mshowa
0 .25 m
.00625 .25 L
s
[(-1)] -0.0125 .25 1 0 Mshowa
0 .375 m
.00625 .375 L
s
[(-0.5)] -0.0125 .375 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .625 m
.00625 .625 L
s
[(0.5)] -0.0125 .625 1 0 Mshowa
0 .75 m
.00625 .75 L
s
[(1)] -0.0125 .75 1 0 Mshowa
0 .875 m
.00625 .875 L
s
[(1.5)] -0.0125 .875 1 0 Mshowa
0 1 m
.00625 1 L
s
[(2)] -0.0125 1 1 0 Mshowa
.125 Mabswid
0 .025 m
.00375 .025 L
s
0 .05 m
.00375 .05 L
s
0 .075 m
.00375 .075 L
s
0 .1 m
.00375 .1 L
s
0 .15 m
.00375 .15 L
s
0 .175 m
.00375 .175 L
s
0 .2 m
.00375 .2 L
s
0 .225 m
.00375 .225 L
s
0 .275 m
.00375 .275 L
s
0 .3 m
.00375 .3 L
s
0 .325 m
.00375 .325 L
s
0 .35 m
.00375 .35 L
s
0 .4 m
.00375 .4 L
s
0 .425 m
.00375 .425 L
s
0 .45 m
.00375 .45 L
s
0 .475 m
.00375 .475 L
s
0 .525 m
.00375 .525 L
s
0 .55 m
.00375 .55 L
s
0 .575 m
.00375 .575 L
s
0 .6 m
.00375 .6 L
s
0 .65 m
.00375 .65 L
s
0 .675 m
.00375 .675 L
s
0 .7 m
.00375 .7 L
s
0 .725 m
.00375 .725 L
s
0 .775 m
.00375 .775 L
s
0 .8 m
.00375 .8 L
s
0 .825 m
.00375 .825 L
s
0 .85 m
.00375 .85 L
s
0 .9 m
.00375 .9 L
s
0 .925 m
.00375 .925 L
s
0 .95 m
.00375 .95 L
s
0 .975 m
.00375 .975 L
s
.25 Mabswid
0 0 m
0 1 L
s
0 .99375 m
0 1 L
s
.125 .99375 m
.125 1 L
s
.25 .99375 m
.25 1 L
s
.375 .99375 m
.375 1 L
s
.5 .99375 m
.5 1 L
s
.625 .99375 m
.625 1 L
s
.75 .99375 m
.75 1 L
s
.875 .99375 m
.875 1 L
s
.125 Mabswid
.025 .99625 m
.025 1 L
s
.05 .99625 m
.05 1 L
s
.075 .99625 m
.075 1 L
s
.1 .99625 m
.1 1 L
s
.15 .99625 m
.15 1 L
s
.175 .99625 m
.175 1 L
s
.2 .99625 m
.2 1 L
s
.225 .99625 m
.225 1 L
s
.275 .99625 m
.275 1 L
s
.3 .99625 m
.3 1 L
s
.325 .99625 m
.325 1 L
s
.35 .99625 m
.35 1 L
s
.4 .99625 m
.4 1 L
s
.425 .99625 m
.425 1 L
s
.45 .99625 m
.45 1 L
s
.475 .99625 m
.475 1 L
s
.525 .99625 m
.525 1 L
s
.55 .99625 m
.55 1 L
s
.575 .99625 m
.575 1 L
s
.6 .99625 m
.6 1 L
s
.65 .99625 m
.65 1 L
s
.675 .99625 m
.675 1 L
s
.7 .99625 m
.7 1 L
s
.725 .99625 m
.725 1 L
s
.775 .99625 m
.775 1 L
s
.8 .99625 m
.8 1 L
s
.825 .99625 m
.825 1 L
s
.85 .99625 m
.85 1 L
s
.9 .99625 m
.9 1 L
s
.925 .99625 m
.925 1 L
s
.95 .99625 m
.95 1 L
s
.975 .99625 m
.975 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 0 m
1 0 L
s
.99375 .125 m
1 .125 L
s
.99375 .25 m
1 .25 L
s
.99375 .375 m
1 .375 L
s
.99375 .5 m
1 .5 L
s
.99375 .625 m
1 .625 L
s
.99375 .75 m
1 .75 L
s
.99375 .875 m
1 .875 L
s
.125 Mabswid
.99625 .025 m
1 .025 L
s
.99625 .05 m
1 .05 L
s
.99625 .075 m
1 .075 L
s
.99625 .1 m
1 .1 L
s
.99625 .15 m
1 .15 L
s
.99625 .175 m
1 .175 L
s
.99625 .2 m
1 .2 L
s
.99625 .225 m
1 .225 L
s
.99625 .275 m
1 .275 L
s
.99625 .3 m
1 .3 L
s
.99625 .325 m
1 .325 L
s
.99625 .35 m
1 .35 L
s
.99625 .4 m
1 .4 L
s
.99625 .425 m
1 .425 L
s
.99625 .45 m
1 .45 L
s
.99625 .475 m
1 .475 L
s
.99625 .525 m
1 .525 L
s
.99625 .55 m
1 .55 L
s
.99625 .575 m
1 .575 L
s
.99625 .6 m
1 .6 L
s
.99625 .65 m
1 .65 L
s
.99625 .675 m
1 .675 L
s
.99625 .7 m
1 .7 L
s
.99625 .725 m
1 .725 L
s
.99625 .775 m
1 .775 L
s
.99625 .8 m
1 .8 L
s
.99625 .825 m
1 .825 L
s
.99625 .85 m
1 .85 L
s
.99625 .9 m
1 .9 L
s
.99625 .925 m
1 .925 L
s
.99625 .95 m
1 .95 L
s
.99625 .975 m
1 .975 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
0 0 m
0 1 L
1 1 L
1 0 L
F
0 0 0 r
.01 w
0 0 m
1 0 L
1 1 L
0 1 L
0 0 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
.01 .66 .62 r
0 0 m
.01 .01 L
s
0 .05 m
.01054 .05943 L
s
0 .1 m
.01113 .10872 L
s
0 .15 m
.01175 .15787 L
s
0 .2 m
.01237 .20686 L
s
0 .25 m
.01292 .25574 L
s
0 .3 m
.01338 .30459 L
s
0 .35 m
.0137 .3535 L
s
0 .4 m
.0139 .40261 L
s
0 .45 m
.014 .45203 L
s
0 .5 m
.01402 .50183 L
s
0 .55 m
.014 .55203 L
s
0 .6 m
.0139 .60261 L
s
0 .65 m
.0137 .6535 L
s
0 .7 m
.01338 .70459 L
s
0 .75 m
.01292 .75574 L
s
0 .8 m
.01237 .80686 L
s
0 .85 m
.01175 .85787 L
s
0 .9 m
.01113 .90872 L
s
0 .95 m
.01054 .95943 L
s
0 1 m
0 1 L
s
.05 0 m
.05943 .01054 L
s
.04 .04 m
.06 .06 L
s
.03934 .09071 m
.06066 .10929 L
s
.0386 .14164 m
.0614 .15836 L
s
.03782 .19282 m
.06218 .20718 L
s
.03708 .24426 m
.06292 .25574 L
s
.03648 .29587 m
.06352 .30413 L
s
.03609 .34747 m
.06391 .35253 L
s
.03591 .39883 m
.06409 .40117 L
s
.03586 .44972 m
.06414 .45028 L
s
.03586 .50004 m
.06414 .49996 L
s
.03586 .54972 m
.06414 .55028 L
s
.03591 .59883 m
.06409 .60117 L
s
.03609 .64747 m
.06391 .65253 L
s
.03648 .69587 m
.06352 .70413 L
s
.03708 .74426 m
.06292 .75574 L
s
.03782 .79282 m
.06218 .80718 L
s
.0386 .84164 m
.0614 .85836 L
s
.03934 .89071 m
.06066 .90929 L
s
.04 .94 m
.06 .96 L
s
.04057 .98946 m
0 0 rlineto s
.04057 .98946 m
.05 1 L
s
.1 0 m
.10872 .01113 L
s
.09071 .03934 m
.10929 .06066 L
s
.09 .09 m
.11 .11 L
s
.08913 .14095 m
.11087 .15905 L
s
.08812 .19233 m
.11188 .20767 L
s
.08708 .24426 m
.11292 .25574 L
s
.08624 .29672 m
.11376 .30328 L
s
.08587 .34941 m
.11413 .35059 L
s
.08596 .40173 m
.11404 .39827 L
s
.08623 .45324 m
.11377 .44676 L
s
.08636 .50375 m
.11364 .49625 L
s
.08623 .55324 m
.11377 .54676 L
s
.08596 .60173 m
.11404 .59827 L
s
.08587 .64941 m
.11413 .65059 L
s
.08624 .69672 m
.11376 .70328 L
s
.08708 .74426 m
.11292 .75574 L
s
.08812 .79233 m
.11188 .80767 L
s
.08913 .84095 m
.11087 .85905 L
s
.09 .89 m
.11 .91 L
s
.09071 .93934 m
.10929 .96066 L
s
.09128 .98887 m
0 0 rlineto s
.09128 .98887 m
.1 1 L
s
.15 0 m
.15787 .01175 L
s
.14164 .0386 m
.15836 .0614 L
s
.14095 .08913 m
.15905 .11087 L
s
.14 .14 m
.16 .16 L
s
.13869 .19151 m
.16131 .20849 L
s
.13708 .24426 m
.16292 .25574 L
s
.13591 .29883 m
.16409 .30117 L
s
.13651 .35426 m
.16349 .34574 L
s
.13844 .40815 m
.16156 .39185 L
s
.14 .46 m
.16 .44 L
s
.14054 .51052 m
.15946 .48948 L
s
.14 .56 m
.16 .54 L
s
.13844 .60815 m
.16156 .59185 L
s
.13651 .65426 m
.16349 .64574 L
s
.13591 .69883 m
.16409 .70117 L
s
.13708 .74426 m
.16292 .75574 L
s
.13869 .79151 m
.16131 .80849 L
s
.14 .84 m
.16 .86 L
s
.14095 .88913 m
.15905 .91087 L
s
.14164 .9386 m
.15836 .9614 L
s
.14213 .98825 m
0 0 rlineto s
.14213 .98825 m
.15 1 L
s
.2 0 m
.20686 .01237 L
s
.19282 .03782 m
.20718 .06218 L
s
.19233 .08812 m
.20767 .11188 L
s
.19151 .13869 m
.20849 .16131 L
s
.19 .19 m
.21 .21 L
s
.18708 .24426 m
.21292 .25574 L
s
.18781 .30716 m
.21219 .29284 L
s
.19533 .36335 m
.20467 .33665 L
s
.19854 .41407 m
.20146 .38593 L
s
.19975 .46414 m
.20025 .43586 L
s
.20008 .51414 m
.19992 .48586 L
s
.19975 .56414 m
.20025 .53586 L
s
.19854 .61407 m
.20146 .58593 L
s
.19533 .66335 m
.20467 .63665 L
s
.18781 .70716 m
.21219 .69284 L
s
.18708 .74426 m
.21292 .75574 L
s
.19 .79 m
.21 .81 L
s
.19151 .83869 m
.20849 .86131 L
s
.19233 .88812 m
.20767 .91188 L
s
.19282 .93782 m
.20718 .96218 L
s
.19314 .98763 m
0 0 rlineto s
.19314 .98763 m
.2 1 L
s
.25 0 m
.25574 .01292 L
s
.24426 .03708 m
.25574 .06292 L
s
.24426 .08708 m
.25574 .11292 L
s
.24426 .13708 m
.25574 .16292 L
s
.24426 .18708 m
.25574 .21292 L
s
newpath
.25 .25 .00707 0 365.73 arc
s
.25574 .31292 m
.24426 .28708 L
s
.25574 .36292 m
.24426 .33708 L
s
.25574 .41292 m
.24426 .38708 L
s
.25574 .46292 m
.24426 .43708 L
s
.25574 .51292 m
.24426 .48708 L
s
.25574 .56292 m
.24426 .53708 L
s
.25574 .61292 m
.24426 .58708 L
s
.25574 .66292 m
.24426 .63708 L
s
.25574 .71292 m
.24426 .68708 L
s
newpath
.25 .75 .00707 0 365.73 arc
s
.24426 .78708 m
.25574 .81292 L
s
.24426 .83708 m
.25574 .86292 L
s
.24426 .88708 m
.25574 .91292 L
s
.24426 .93708 m
.25574 .96292 L
s
.24426 .98708 m
0 0 rlineto s
.24426 .98708 m
.25 1 L
s
.3 0 m
.30459 .01338 L
s
.29587 .03648 m
.30413 .06352 L
s
.29672 .08624 m
.30328 .11376 L
s
.29883 .13591 m
.30117 .16409 L
s
.30716 .18781 m
.29284 .21219 L
s
.31292 .25574 m
.28708 .24426 L
s
.31 .31 m
.29 .29 L
s
.30887 .36101 m
.29113 .33899 L
s
.30836 .4114 m
.29164 .3886 L
s
.30813 .46157 m
.29187 .43843 L
s
.30806 .51162 m
.29194 .48838 L
s
.30813 .56157 m
.29187 .53843 L
s
.30836 .6114 m
.29164 .5886 L
s
.30887 .66101 m
.29113 .63899 L
s
.31 .71 m
.29 .69 L
s
.31292 .75574 m
.28708 .74426 L
s
.30716 .78781 m
.29284 .81219 L
s
.29883 .83591 m
.30117 .86409 L
s
.29672 .88624 m
.30328 .91376 L
s
.29587 .93648 m
.30413 .96352 L
s
.29541 .98662 m
0 0 rlineto s
.29541 .98662 m
.3 1 L
s
.35 0 m
.3535 .0137 L
s
.34747 .03609 m
.35253 .06391 L
s
.34941 .08587 m
.35059 .11413 L
s
.35426 .13651 m
.34574 .16349 L
s
.36335 .19533 m
.33665 .20467 L
s
.36292 .25574 m
.33708 .24426 L
s
.36101 .30887 m
.33899 .29113 L
s
.36 .36 m
.34 .34 L
s
.35947 .41051 m
.34053 .38949 L
s
.3592 .46074 m
.3408 .43926 L
s
.35912 .51081 m
.34088 .48919 L
s
.3592 .56074 m
.3408 .53926 L
s
.35947 .61051 m
.34053 .58949 L
s
.36 .66 m
.34 .64 L
s
.36101 .70887 m
.33899 .69113 L
s
.36292 .75574 m
.33708 .74426 L
s
.36335 .79533 m
.33665 .80467 L
s
.35426 .83651 m
.34574 .86349 L
s
.34941 .88587 m
.35059 .91413 L
s
.34747 .93609 m
.35253 .96391 L
s
.3465 .9863 m
0 0 rlineto s
.3465 .9863 m
.35 1 L
s
.4 0 m
.40261 .0139 L
s
.39883 .03591 m
.40117 .06409 L
s
.40173 .08596 m
.39827 .11404 L
s
.40815 .13844 m
.39185 .16156 L
s
.41407 .19854 m
.38593 .20146 L
s
.41292 .25574 m
.38708 .24426 L
s
.4114 .30836 m
.3886 .29164 L
s
.41051 .35947 m
.38949 .34053 L
s
.41 .41 m
.39 .39 L
s
.40974 .46025 m
.39026 .43975 L
s
.40966 .51033 m
.39034 .48967 L
s
.40974 .56025 m
.39026 .53975 L
s
.41 .61 m
.39 .59 L
s
.41051 .65947 m
.38949 .64053 L
s
.4114 .70836 m
.3886 .69164 L
s
.41292 .75574 m
.38708 .74426 L
s
.41407 .79854 m
.38593 .80146 L
s
.40815 .83844 m
.39185 .86156 L
s
.40173 .88596 m
.39827 .91404 L
s
.39883 .93591 m
.40117 .96409 L
s
.39739 .9861 m
0 0 rlineto s
.39739 .9861 m
.4 1 L
s
.45 0 m
.45203 .014 L
s
.44972 .03586 m
.45028 .06414 L
s
.45324 .08623 m
.44676 .11377 L
s
.46 .14 m
.44 .16 L
s
.46414 .19975 m
.43586 .20025 L
s
.46292 .25574 m
.43708 .24426 L
s
.46157 .30813 m
.43843 .29187 L
s
.46074 .3592 m
.43926 .3408 L
s
.46025 .40974 m
.43975 .39026 L
s
.46 .46 m
.44 .44 L
s
.45992 .51008 m
.44008 .48992 L
s
.46 .56 m
.44 .54 L
s
.46025 .60974 m
.43975 .59026 L
s
.46074 .6592 m
.43926 .6408 L
s
.46157 .70813 m
.43843 .69187 L
s
.46292 .75574 m
.43708 .74426 L
s
.46414 .79975 m
.43586 .80025 L
s
.46 .84 m
.44 .86 L
s
.45324 .88623 m
.44676 .91377 L
s
.44972 .93586 m
.45028 .96414 L
s
.44797 .986 m
0 0 rlineto s
.44797 .986 m
.45 1 L
s
.5 0 m
.50183 .01402 L
s
.50004 .03586 m
.49996 .06414 L
s
.50375 .08636 m
.49625 .11364 L
s
.51052 .14054 m
.48948 .15946 L
s
.51414 .20008 m
.48586 .19992 L
s
.51292 .25574 m
.48708 .24426 L
s
.51162 .30806 m
.48838 .29194 L
s
.51081 .35912 m
.48919 .34088 L
s
.51033 .40966 m
.48967 .39034 L
s
.51008 .45992 m
.48992 .44008 L
s
.51 .51 m
.49 .49 L
s
.51008 .55992 m
.48992 .54008 L
s
.51033 .60966 m
.48967 .59034 L
s
.51081 .65912 m
.48919 .64088 L
s
.51162 .70806 m
.48838 .69194 L
s
.51292 .75574 m
.48708 .74426 L
s
.51414 .80008 m
.48586 .79992 L
s
.51052 .84054 m
.48948 .85946 L
s
.50375 .88636 m
.49625 .91364 L
s
.50004 .93586 m
.49996 .96414 L
s
.49817 .98598 m
0 0 rlineto s
.49817 .98598 m
.5 1 L
s
.55 0 m
.55203 .014 L
s
.54972 .03586 m
.55028 .06414 L
s
.55324 .08623 m
.54676 .11377 L
s
.56 .14 m
.54 .16 L
s
.56414 .19975 m
.53586 .20025 L
s
.56292 .25574 m
.53708 .24426 L
s
.56157 .30813 m
.53843 .29187 L
s
.56074 .3592 m
.53926 .3408 L
s
.56025 .40974 m
.53975 .39026 L
s
.56 .46 m
.54 .44 L
s
.55992 .51008 m
.54008 .48992 L
s
.56 .56 m
.54 .54 L
s
.56025 .60974 m
.53975 .59026 L
s
.56074 .6592 m
.53926 .6408 L
s
.56157 .70813 m
.53843 .69187 L
s
.56292 .75574 m
.53708 .74426 L
s
.56414 .79975 m
.53586 .80025 L
s
.56 .84 m
.54 .86 L
s
.55324 .88623 m
.54676 .91377 L
s
.54972 .93586 m
.55028 .96414 L
s
.54797 .986 m
0 0 rlineto s
.54797 .986 m
.55 1 L
s
.6 0 m
.60261 .0139 L
s
.59883 .03591 m
.60117 .06409 L
s
.60173 .08596 m
.59827 .11404 L
s
.60815 .13844 m
.59185 .16156 L
s
.61407 .19854 m
.58593 .20146 L
s
.61292 .25574 m
.58708 .24426 L
s
.6114 .30836 m
.5886 .29164 L
s
.61051 .35947 m
.58949 .34053 L
s
.61 .41 m
.59 .39 L
s
.60974 .46025 m
.59026 .43975 L
s
.60966 .51033 m
.59034 .48967 L
s
.60974 .56025 m
.59026 .53975 L
s
.61 .61 m
.59 .59 L
s
.61051 .65947 m
.58949 .64053 L
s
.6114 .70836 m
.5886 .69164 L
s
.61292 .75574 m
.58708 .74426 L
s
.61407 .79854 m
.58593 .80146 L
s
.60815 .83844 m
.59185 .86156 L
s
.60173 .88596 m
.59827 .91404 L
s
.59883 .93591 m
.60117 .96409 L
s
.59739 .9861 m
0 0 rlineto s
.59739 .9861 m
.6 1 L
s
.65 0 m
.6535 .0137 L
s
.64747 .03609 m
.65253 .06391 L
s
.64941 .08587 m
.65059 .11413 L
s
.65426 .13651 m
.64574 .16349 L
s
.66335 .19533 m
.63665 .20467 L
s
.66292 .25574 m
.63708 .24426 L
s
.66101 .30887 m
.63899 .29113 L
s
.66 .36 m
.64 .34 L
s
.65947 .41051 m
.64053 .38949 L
s
.6592 .46074 m
.6408 .43926 L
s
.65912 .51081 m
.64088 .48919 L
s
.6592 .56074 m
.6408 .53926 L
s
.65947 .61051 m
.64053 .58949 L
s
.66 .66 m
.64 .64 L
s
.66101 .70887 m
.63899 .69113 L
s
.66292 .75574 m
.63708 .74426 L
s
.66335 .79533 m
.63665 .80467 L
s
.65426 .83651 m
.64574 .86349 L
s
.64941 .88587 m
.65059 .91413 L
s
.64747 .93609 m
.65253 .96391 L
s
.6465 .9863 m
0 0 rlineto s
.6465 .9863 m
.65 1 L
s
.7 0 m
.70459 .01338 L
s
.69587 .03648 m
.70413 .06352 L
s
.69672 .08624 m
.70328 .11376 L
s
.69883 .13591 m
.70117 .16409 L
s
.70716 .18781 m
.69284 .21219 L
s
.71292 .25574 m
.68708 .24426 L
s
.71 .31 m
.69 .29 L
s
.70887 .36101 m
.69113 .33899 L
s
.70836 .4114 m
.69164 .3886 L
s
.70813 .46157 m
.69187 .43843 L
s
.70806 .51162 m
.69194 .48838 L
s
.70813 .56157 m
.69187 .53843 L
s
.70836 .6114 m
.69164 .5886 L
s
.70887 .66101 m
.69113 .63899 L
s
.71 .71 m
.69 .69 L
s
.71292 .75574 m
.68708 .74426 L
s
.70716 .78781 m
.69284 .81219 L
s
.69883 .83591 m
.70117 .86409 L
s
.69672 .88624 m
.70328 .91376 L
s
.69587 .93648 m
.70413 .96352 L
s
.69541 .98662 m
0 0 rlineto s
.69541 .98662 m
.7 1 L
s
.75 0 m
.75574 .01292 L
s
.74426 .03708 m
.75574 .06292 L
s
.74426 .08708 m
.75574 .11292 L
s
.74426 .13708 m
.75574 .16292 L
s
.74426 .18708 m
.75574 .21292 L
s
newpath
.75 .25 .00707 0 365.73 arc
s
.75574 .31292 m
.74426 .28708 L
s
.75574 .36292 m
.74426 .33708 L
s
.75574 .41292 m
.74426 .38708 L
s
.75574 .46292 m
.74426 .43708 L
s
.75574 .51292 m
.74426 .48708 L
s
.75574 .56292 m
.74426 .53708 L
s
.75574 .61292 m
.74426 .58708 L
s
.75574 .66292 m
.74426 .63708 L
s
.75574 .71292 m
.74426 .68708 L
s
newpath
.75 .75 .00707 0 365.73 arc
s
.74426 .78708 m
.75574 .81292 L
s
.74426 .83708 m
.75574 .86292 L
s
.74426 .88708 m
.75574 .91292 L
s
.74426 .93708 m
.75574 .96292 L
s
.74426 .98708 m
0 0 rlineto s
.74426 .98708 m
.75 1 L
s
.8 0 m
.80686 .01237 L
s
.79282 .03782 m
.80718 .06218 L
s
.79233 .08812 m
.80767 .11188 L
s
.79151 .13869 m
.80849 .16131 L
s
.79 .19 m
.81 .21 L
s
.78708 .24426 m
.81292 .25574 L
s
.78781 .30716 m
.81219 .29284 L
s
.79533 .36335 m
.80467 .33665 L
s
.79854 .41407 m
.80146 .38593 L
s
.79975 .46414 m
.80025 .43586 L
s
.80008 .51414 m
.79992 .48586 L
s
.79975 .56414 m
.80025 .53586 L
s
.79854 .61407 m
.80146 .58593 L
s
.79533 .66335 m
.80467 .63665 L
s
.78781 .70716 m
.81219 .69284 L
s
.78708 .74426 m
.81292 .75574 L
s
.79 .79 m
.81 .81 L
s
.79151 .83869 m
.80849 .86131 L
s
.79233 .88812 m
.80767 .91188 L
s
.79282 .93782 m
.80718 .96218 L
s
.79314 .98763 m
0 0 rlineto s
.79314 .98763 m
.8 1 L
s
.85 0 m
.85787 .01175 L
s
.84164 .0386 m
.85836 .0614 L
s
.84095 .08913 m
.85905 .11087 L
s
.84 .14 m
.86 .16 L
s
.83869 .19151 m
.86131 .20849 L
s
.83708 .24426 m
.86292 .25574 L
s
.83591 .29883 m
.86409 .30117 L
s
.83651 .35426 m
.86349 .34574 L
s
.83844 .40815 m
.86156 .39185 L
s
.84 .46 m
.86 .44 L
s
.84054 .51052 m
.85946 .48948 L
s
.84 .56 m
.86 .54 L
s
.83844 .60815 m
.86156 .59185 L
s
.83651 .65426 m
.86349 .64574 L
s
.83591 .69883 m
.86409 .70117 L
s
.83708 .74426 m
.86292 .75574 L
s
.83869 .79151 m
.86131 .80849 L
s
.84 .84 m
.86 .86 L
s
.84095 .88913 m
.85905 .91087 L
s
.84164 .9386 m
.85836 .9614 L
s
.84213 .98825 m
0 0 rlineto s
.84213 .98825 m
.85 1 L
s
.9 0 m
.90872 .01113 L
s
.89071 .03934 m
.90929 .06066 L
s
.89 .09 m
.91 .11 L
s
.88913 .14095 m
.91087 .15905 L
s
.88812 .19233 m
.91188 .20767 L
s
.88708 .24426 m
.91292 .25574 L
s
.88624 .29672 m
.91376 .30328 L
s
.88587 .34941 m
.91413 .35059 L
s
.88596 .40173 m
.91404 .39827 L
s
.88623 .45324 m
.91377 .44676 L
s
.88636 .50375 m
.91364 .49625 L
s
.88623 .55324 m
.91377 .54676 L
s
.88596 .60173 m
.91404 .59827 L
s
.88587 .64941 m
.91413 .65059 L
s
.88624 .69672 m
.91376 .70328 L
s
.88708 .74426 m
.91292 .75574 L
s
.88812 .79233 m
.91188 .80767 L
s
.88913 .84095 m
.91087 .85905 L
s
.89 .89 m
.91 .91 L
s
.89071 .93934 m
.90929 .96066 L
s
.89128 .98887 m
0 0 rlineto s
.89128 .98887 m
.9 1 L
s
.95 0 m
.95943 .01054 L
s
.94 .04 m
.96 .06 L
s
.93934 .09071 m
.96066 .10929 L
s
.9386 .14164 m
.9614 .15836 L
s
.93782 .19282 m
.96218 .20718 L
s
.93708 .24426 m
.96292 .25574 L
s
.93648 .29587 m
.96352 .30413 L
s
.93609 .34747 m
.96391 .35253 L
s
.93591 .39883 m
.96409 .40117 L
s
.93586 .44972 m
.96414 .45028 L
s
.93586 .50004 m
.96414 .49996 L
s
.93586 .54972 m
.96414 .55028 L
s
.93591 .59883 m
.96409 .60117 L
s
.93609 .64747 m
.96391 .65253 L
s
.93648 .69587 m
.96352 .70413 L
s
.93708 .74426 m
.96292 .75574 L
s
.93782 .79282 m
.96218 .80718 L
s
.9386 .84164 m
.9614 .85836 L
s
.93934 .89071 m
.96066 .90929 L
s
.94 .94 m
.96 .96 L
s
.94057 .98946 m
0 0 rlineto s
.94057 .98946 m
.95 1 L
s
.98946 .04057 m
0 0 rlineto s
.98946 .04057 m
1 .05 L
s
.98887 .09128 m
0 0 rlineto s
.98887 .09128 m
1 .1 L
s
.98825 .14213 m
0 0 rlineto s
.98825 .14213 m
1 .15 L
s
.98763 .19314 m
0 0 rlineto s
.98763 .19314 m
1 .2 L
s
.98708 .24426 m
0 0 rlineto s
.98708 .24426 m
1 .25 L
s
.98662 .29541 m
0 0 rlineto s
.98662 .29541 m
1 .3 L
s
.9863 .3465 m
0 0 rlineto s
.9863 .3465 m
1 .35 L
s
.9861 .39739 m
0 0 rlineto s
.9861 .39739 m
1 .4 L
s
.986 .44797 m
0 0 rlineto s
.986 .44797 m
1 .45 L
s
.98598 .49817 m
0 0 rlineto s
.98598 .49817 m
1 .5 L
s
.986 .54797 m
0 0 rlineto s
.986 .54797 m
1 .55 L
s
.9861 .59739 m
0 0 rlineto s
.9861 .59739 m
1 .6 L
s
.9863 .6465 m
0 0 rlineto s
.9863 .6465 m
1 .65 L
s
.98662 .69541 m
0 0 rlineto s
.98662 .69541 m
1 .7 L
s
.98708 .74426 m
0 0 rlineto s
.98708 .74426 m
1 .75 L
s
.98763 .79314 m
0 0 rlineto s
.98763 .79314 m
1 .8 L
s
.98825 .84213 m
0 0 rlineto s
.98825 .84213 m
1 .85 L
s
.98887 .89128 m
0 0 rlineto s
.98887 .89128 m
1 .9 L
s
.98946 .94057 m
0 0 rlineto s
.98946 .94057 m
1 .95 L
s
.99 .99 m
0 0 rlineto s
.99 .99 m
1 1 L
s
.57 .13 .62 r
.005 w
.33333 .875 m
.33333 .875 L
.33333 .875 L
s
.75 .75 m
.75 .75 L
.75 .75 L
s
.41667 .06698 m
.45833 .05365 L
.5 .0493 L
.54167 .05365 L
.58333 .06698 L
.61542 .08333 L
.625 .09015 L
.66667 .125 L
.66667 .125 L
.70231 .16667 L
.70833 .17522 L
.72915 .20833 L
.75 .25 L
.75 .25 L
.76649 .29167 L
.77921 .33333 L
.78869 .375 L
.79167 .39063 L
.79529 .41667 L
.7992 .45833 L
.80048 .5 L
.7992 .54167 L
.79529 .58333 L
.79167 .60937 L
.78869 .625 L
.77921 .66667 L
.76649 .70833 L
.75 .75 L
.75 .75 L
.72915 .79167 L
.70833 .82478 L
.70231 .83333 L
.66667 .875 L
.66667 .875 L
.625 .90985 L
.61542 .91667 L
.58333 .93302 L
.54167 .94635 L
.5 .9507 L
.45833 .94635 L
.41667 .93302 L
.38458 .91667 L
.375 .90985 L
.33333 .875 L
.33333 .875 L
.29769 .83333 L
.29167 .82478 L
.27085 .79167 L
.25 .75 L
.25 .75 L
Mistroke
.23351 .70833 L
.22079 .66667 L
.21131 .625 L
.20833 .60937 L
.20471 .58333 L
.2008 .54167 L
.19952 .5 L
.2008 .45833 L
.20471 .41667 L
.20833 .39063 L
.21131 .375 L
.22079 .33333 L
.23351 .29167 L
.25 .25 L
.25 .25 L
.27085 .20833 L
.29167 .17522 L
.29769 .16667 L
.33333 .125 L
.33333 .125 L
.375 .09015 L
.38458 .08333 L
.41667 .06698 L
Mfstroke
.274 .51 .706 r
.75 .75 m
.75 .75 L
s
.41667 .20471 m
.45833 .2008 L
.5 .19952 L
.54167 .2008 L
.58333 .20471 L
.60937 .20833 L
.625 .21131 L
.66667 .22079 L
.70833 .23351 L
.75 .25 L
.75 .25 L
.79167 .27085 L
.82478 .29167 L
.83333 .29769 L
.875 .33333 L
.875 .33333 L
.90985 .375 L
.91667 .38458 L
.93302 .41667 L
.94635 .45833 L
.9507 .5 L
.94635 .54167 L
.93302 .58333 L
.91667 .61542 L
.90985 .625 L
.875 .66667 L
.875 .66667 L
.83333 .70231 L
.82478 .70833 L
.79167 .72915 L
.75 .75 L
.75 .75 L
.70833 .76649 L
.66667 .77921 L
.625 .78869 L
.60937 .79167 L
.58333 .79529 L
.54167 .7992 L
.5 .80048 L
.45833 .7992 L
.41667 .79529 L
.39063 .79167 L
.375 .78869 L
.33333 .77921 L
.29167 .76649 L
.25 .75 L
.25 .75 L
.20833 .72915 L
.17522 .70833 L
.16667 .70231 L
Mistroke
.125 .66667 L
.125 .66667 L
.09015 .625 L
.08333 .61542 L
.06698 .58333 L
.05365 .54167 L
.0493 .5 L
.05365 .45833 L
.06698 .41667 L
.08333 .38458 L
.09015 .375 L
.125 .33333 L
.125 .33333 L
.16667 .29769 L
.17522 .29167 L
.20833 .27085 L
.25 .25 L
.25 .25 L
.29167 .23351 L
.33333 .22079 L
.375 .21131 L
.39063 .20833 L
.41667 .20471 L
Mfstroke
.89 .09 .05 r
.25 .75 m
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
.25 .75 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.7498 .7502 L
.74846 .7515 L
.73904 .75935 L
.73138 .7645 L
.71886 .77129 L
.70844 .77579 L
.69298 .78105 L
.67403 .78571 L
.6513 .78934 L
.6195 .79165 L
.58277 .79116 L
.53542 .78639 L
.50634 .78133 L
.47877 .77501 L
.42616 .75835 L
.39738 .74607 L
.37195 .73274 L
.32581 .69994 L
.30348 .67803 L
.28542 .6559 L
.25848 .61188 L
.23888 .56638 L
.22329 .51441 L
.213 .4603 L
.21013 .43518 L
.2085 .40989 L
.20878 .37029 L
.21185 .33984 L
Mistroke
.21603 .31806 L
.22078 .30112 L
.22521 .28906 L
.23249 .27377 L
.2428 .25813 L
.2499 .2501 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mfstroke
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.74982 .75018 L
.74858 .75139 L
.74573 .75398 L
.74213 .75694 L
.73586 .76136 L
.72588 .76695 L
.71718 .77066 L
.70631 .77409 L
.68984 .77729 L
.6778 .77839 L
.66451 .77858 L
.63353 .77557 L
.5897 .76467 L
.54376 .74637 L
.48604 .71454 L
.4271 .67202 L
.37406 .62406 L
.31907 .56167 L
Mistroke
.2733 .49388 L
.2451 .43682 L
.23019 .39297 L
.22264 .35353 L
.22149 .3378 L
.22156 .32326 L
.22378 .30328 L
.22701 .28977 L
.22913 .28338 L
.23113 .27834 L
.23464 .27097 L
.24082 .26089 L
.24877 .25125 L
.24998 .25002 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mfstroke
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.74996 .75004 L
.74969 .75031 L
.74901 .75097 L
.74701 .75278 L
.74501 .75439 L
.74119 .75691 L
.73797 .75852 L
.73554 .75947 L
.73274 .76033 L
.72613 .76147 L
.71542 .76137 L
.70168 .75881 L
.67916 .75081 L
.64334 .73211 L
.595 .69985 L
.47283 .59683 L
.33978 .45573 L
.28766 .38738 L
.25941 .34173 L
.24493 .31019 L
.24121 .29842 L
.23913 .28858 L
.23836 .27629 L
.23933 .26867 L
.24071 .26395 L
.24229 .2603 L
Mistroke
.24533 .25537 L
.2474 .25278 L
.24913 .25088 L
.24999 .25001 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mfstroke
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.48179 .48179 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75004 .74996 L
.7503 .7497 L
.75195 .74796 L
.75479 .74446 L
.75611 .74252 L
.75757 .73996 L
.75901 .73678 L
Mistroke
.76053 .73193 L
.76124 .72816 L
.76164 .72375 L
.76101 .71239 L
.75929 .70355 L
.75629 .6933 L
.75076 .67906 L
.74143 .65984 L
.67244 .55926 L
.52091 .3973 L
.38186 .2839 L
.35556 .26723 L
.33318 .25497 L
.30455 .24301 L
.28748 .23897 L
.27686 .23834 L
.26902 .23926 L
.2658 .24009 L
.2634 .24092 L
.26015 .24237 L
.25791 .24362 L
.2546 .24591 L
.25162 .24843 L
.25002 .24998 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mfstroke
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75007 .74993 L
.7506 .74939 L
.75438 .74527 L
.76123 .73608 L
.76441 .73078 L
.76796 .72372 L
.77145 .71499 L
.77518 .70185 L
.77804 .6829 L
.77862 .66882 L
.77797 .6529 L
.77547 .63294 L
.77093 .61137 L
.76269 .58382 L
.7494 .55037 L
.71428 .48563 L
.66606 .41987 L
.59934 .35063 L
.52217 .29076 L
.46004 .25543 L
.42884 .24193 L
.40288 .233 L
.36012 .22346 L
.34127 .22164 L
.32684 .22143 L
.30664 .22321 L
.29082 .2267 L
.28014 .23038 L
Mistroke
.27289 .23366 L
.25673 .24397 L
.25195 .24811 L
.25003 .24997 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mfstroke
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.7502 .7498 L
.7515 .74846 L
.75935 .73904 L
.7645 .73138 L
.77129 .71886 L
.77579 .70844 L
.78105 .69298 L
.78571 .67403 L
.78934 .6513 L
.79165 .6195 L
.79116 .58277 L
.78639 .53542 L
.78133 .50634 L
.77501 .47877 L
.75835 .42616 L
.74607 .39738 L
.73274 .37195 L
.69994 .32581 L
.67803 .30348 L
.6559 .28542 L
.61188 .25848 L
.56638 .23888 L
.51441 .22329 L
.4603 .213 L
.43518 .21013 L
.40989 .2085 L
.37029 .20878 L
.33984 .21185 L
Mistroke
.31806 .21603 L
.30112 .22078 L
.28906 .22521 L
.27377 .23249 L
.25813 .2428 L
.2501 .2499 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mfstroke
.75 .25 m
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
.75 .25 L
s
0 0 m
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .0625 m
.18814 .21926 L
.22742 .24626 L
.23265 .24902 L
.23629 .25066 L
.23882 .25159 L
.2409 .25218 L
.24265 .2525 L
.2439 .2526 L
.24496 .25258 L
.24546 .25253 L
.24587 .25246 L
.24651 .2523 L
.24708 .25211 L
.24785 .25174 L
.24874 .25115 L
.24959 .25041 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .125 m
.12166 .20919 L
.17858 .24268 L
.19453 .25034 L
.20565 .25482 L
.21325 .25729 L
.21978 .25888 L
.22535 .2597 L
.22988 .25987 L
.23315 .25963 L
.23563 .25919 L
.23797 .25853 L
.23971 .25786 L
.24261 .25634 L
.24578 .25402 L
.24763 .25235 L
.24915 .25086 L
.24999 .25001 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .1875 m
.11391 .24796 L
.14749 .26186 L
.16968 .26901 L
.18487 .27246 L
.19728 .27398 L
.20593 .27409 L
.21229 .27351 L
.21833 .2723 L
.22287 .27088 L
.22691 .26916 L
.23043 .26727 L
.23917 .26081 L
.24866 .25136 L
.24998 .25002 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mistroke
Mfstroke
0 .25 m
.06667 .27706 L
.10719 .28991 L
.13973 .29687 L
.16157 .29887 L
.17667 .29838 L
.18754 .2967 L
.19701 .29406 L
.20498 .29077 L
.2114 .28727 L
.217 .28352 L
.22469 .27717 L
.23548 .2661 L
.24811 .25194 L
.24998 .25002 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .3125 m
.06287 .32945 L
.10162 .33544 L
.13309 .33607 L
.15444 .3331 L
.16935 .32862 L
.1802 .32368 L
.18976 .31785 L
.19793 .31157 L
.21896 .28915 L
.23146 .27258 L
.24747 .25263 L
.24997 .25003 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mistroke
.25 .25 L
Mfstroke
0 .375 m
.06006 .38449 L
.09737 .38507 L
.12783 .38032 L
.14858 .3728 L
.16312 .36444 L
.17375 .35617 L
.1913 .33734 L
.21332 .30387 L
.22695 .28087 L
.2467 .25348 L
.24996 .25004 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
Mistroke
Mfstroke
0 .4375 m
.05833 .4424 L
.09466 .43938 L
.12429 .43071 L
.14439 .4195 L
.15841 .40771 L
.16862 .39626 L
.18545 .37038 L
.22176 .29215 L
.23886 .26322 L
.2457 .25461 L
.24842 .25163 L
.24948 .25052 L
.24995 .25005 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .49996 m
.24429 .25626 L
.24993 .25007 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .56244 m
.24201 .25911 L
.2499 .2501 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .62493 m
.2369 .26629 L
.24982 .25018 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
.25 .25 L
s
0 .6875 m
.04768 .7026 L
.08712 .71499 L
.11583 .72409 L
.13794 .7313 L
.15704 .73783 L
.17214 .74338 L
.18545 .74878 L
.19621 .75373 L
.20505 .75842 L
.21318 .76352 L
.22001 .76868 L
.22589 .77402 L
.23157 .78028 L
.23664 .78705 L
.24177 .79529 L
.24663 .80451 L
.25137 .81488 L
.25667 .82799 L
.26224 .84317 L
.26898 .86288 L
.27665 .8865 L
.28567 .91498 L
.29788 .95386 L
s
.29788 .95386 m
.3125 1 L
s
0 .75 m
.019 .75863 L
.03789 .76766 L
.05409 .77585 L
.06845 .78356 L
.08258 .79165 L
.0952 .7994 L
.1077 .80767 L
.11896 .81574 L
.12917 .82365 L
.13944 .83228 L
.14884 .84088 L
.15749 .84945 L
.16634 .859 L
.17458 .86865 L
.1831 .87949 L
.19114 .89058 L
.19877 .90196 L
.20685 .91492 L
.21466 .92835 L
.22305 .94381 L
.23132 .96003 L
.23952 .97706 L
.24863 .99693 L
s
.24863 .99693 m
.24998 1 L
s
0 .8125 m
.01104 .81907 L
.02259 .82624 L
.03295 .83296 L
.04251 .83944 L
.05228 .84638 L
.06134 .85311 L
.07061 .86034 L
.07923 .86741 L
.08726 .87433 L
.09555 .88183 L
.1033 .88921 L
.11057 .89647 L
.11813 .90441 L
.12525 .91226 L
.13267 .92088 L
.1397 .92945 L
.14637 .93798 L
.15339 .9474 L
.16009 .95682 L
.16718 .96726 L
.17398 .97776 L
.18054 .98832 L
s
.18054 .98832 m
.1875 1 L
s
0 .875 m
.00662 .87987 L
.01373 .88526 L
.02026 .89036 L
.02641 .8953 L
.03282 .9006 L
.03887 .90575 L
.04518 .91128 L
.05115 .91668 L
.05679 .92193 L
.06269 .92759 L
.06829 .93313 L
.07359 .93852 L
.07916 .94436 L
.08444 .95008 L
.09 .95626 L
.09529 .96233 L
.10032 .96828 L
.10563 .97474 L
.1107 .98109 L
.11605 .98798 L
.12117 .99478 L
s
.12117 .99478 m
.12499 1 L
s
0 .9375 m
.00295 .94007 L
.0062 .94295 L
.00923 .94566 L
.01213 .94829 L
.01518 .9511 L
.0181 .95382 L
.02118 .95673 L
.02413 .95954 L
.02694 .96227 L
.02991 .96519 L
.03276 .96802 L
.03547 .97076 L
.03835 .97369 L
.0411 .97654 L
.044 .97958 L
.04678 .98254 L
.04944 .9854 L
.05226 .98848 L
.05496 .99146 L
.05781 .99465 L
.06054 .99775 L
s
.06054 .99775 m
.0625 1 L
s
.9375 0 m
.93969 .00251 L
.94228 .00545 L
.94506 .00856 L
.94775 .01153 L
.95062 .01466 L
.9534 .01766 L
.95609 .02051 L
.95897 .02353 L
.96176 .02642 L
.96446 .02918 L
.96735 .03209 L
.97016 .03488 L
.97316 .03782 L
.97607 .04064 L
.97888 .04334 L
.9819 .04619 L
.98483 .04892 L
.98797 .0518 L
.99102 .05456 L
.99397 .05721 L
.99714 .06001 L
s
.99714 .06001 m
1 .0625 L
s
.87501 0 m
.87925 .00579 L
.88412 .01224 L
.88933 .01895 L
.89438 .02528 L
.89979 .03186 L
.90506 .03807 L
.91018 .04394 L
.91569 .05007 L
.92106 .05586 L
.92629 .06135 L
.93193 .06709 L
.93745 .07254 L
.94341 .07825 L
.94924 .08368 L
.95495 .08884 L
.96114 .09426 L
.96722 .09943 L
.9738 .10487 L
.98028 .11007 L
.98665 .11503 L
.99358 .12027 L
s
.99358 .12027 m
1 .125 L
s
.8125 0 m
.81265 .00026 L
.81985 .01232 L
.82658 .02313 L
.83304 .03308 L
.83994 .04323 L
.84662 .05262 L
.85378 .06222 L
.86076 .07113 L
.86757 .07941 L
.87493 .08794 L
.88216 .0959 L
.88926 .10335 L
.897 .11109 L
.90465 .11835 L
.91302 .12591 L
.92133 .13305 L
.92959 .13981 L
.93869 .14691 L
.94777 .15366 L
.95781 .16078 L
.9679 .1676 L
.97802 .17415 L
.98928 .18113 L
s
.98928 .18113 m
1 .1875 L
s
.75003 0 m
.75163 .00366 L
.76097 .024 L
.76937 .04136 L
.77722 .05669 L
.78539 .07173 L
.79316 .08511 L
.8014 .09832 L
.80939 .11017 L
.81717 .12087 L
.82563 .1316 L
.834 .14138 L
.84231 .15034 L
.85152 .15947 L
.8608 .16793 L
.87117 .17663 L
.88176 .1848 L
.89256 .19251 L
.90483 .20062 L
.9175 .20839 L
.93202 .2167 L
.94721 .22482 L
.96309 .23282 L
.98154 .24162 L
s
.98154 .24162 m
1 .25 L
s
.6875 0 m
.70251 .0474 L
.71492 .08691 L
.72404 .11566 L
.73125 .1378 L
.73779 .15693 L
.74334 .17204 L
.74875 .18538 L
.75369 .19615 L
.75839 .205 L
.76349 .21313 L
.76864 .21997 L
.77398 .22585 L
.78024 .23153 L
.78701 .23661 L
.79523 .24174 L
.80444 .2466 L
.81481 .25133 L
.8279 .25663 L
.84306 .2622 L
.86275 .26893 L
.88632 .2766 L
.91476 .2856 L
.95357 .2978 L
s
.95357 .2978 m
1 .3125 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75019 .74981 L
.75145 .74851 L
.75903 .73951 L
.76432 .73181 L
.77135 .71928 L
.78084 .69648 L
.78637 .67826 L
.79212 .65247 L
.79485 .63596 L
.79708 .61882 L
.79916 .59791 L
.80091 .57357 L
.80208 .5509 L
.803 .52875 L
.80407 .50232 L
.8047 .48929 L
.80541 .47732 L
.80724 .45587 L
Mistroke
.81039 .43376 L
.81447 .41649 L
.82083 .4 L
.82562 .39167 L
.83201 .38359 L
.84762 .3717 L
.86962 .36411 L
.89838 .36143 L
.93728 .36395 L
Mfstroke
.93728 .36395 m
1 .375 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75011 .74989 L
.75085 .74914 L
.75542 .74408 L
.76353 .73312 L
.77067 .72093 L
.78127 .69684 L
.80607 .58957 L
.80993 .56751 L
.81485 .54248 L
.82083 .51853 L
.82828 .49695 L
.83745 .4786 L
.85153 .4605 L
.8608 .45255 L
.87289 .44511 L
.90223 .43538 L
.94377 .43226 L
s
.94377 .43226 m
1 .4375 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75008 .74992 L
.75067 .74932 L
.75187 .74807 L
.75475 .74486 L
.76136 .73637 L
.77616 .7105 L
.78819 .68066 L
.80472 .62784 L
.81559 .59408 L
.82253 .57624 L
.8305 .55956 L
.83964 .54463 L
.85213 .52963 L
.8688 .51611 L
.89415 .50421 L
.91253 .49961 L
.9371 .49681 L
s
.9371 .49681 m
1 .5 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.7501 .7499 L
.75089 .7491 L
.7523 .74762 L
.75638 .74295 L
.76484 .73142 L
.78058 .70307 L
.79395 .67338 L
.81291 .63266 L
.82945 .60623 L
Mistroke
.84271 .5912 L
.85911 .57813 L
.87954 .56773 L
.90443 .56079 L
.94458 .55761 L
Mfstroke
.94458 .55761 m
1 .5625 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75003 .74997 L
.75231 .7476 L
Mistroke
.75639 .74296 L
.76797 .72713 L
.77897 .70928 L
.79561 .68144 L
.80656 .66545 L
.82295 .64684 L
.83479 .63702 L
.85184 .627 L
.8728 .61952 L
.89934 .61517 L
.93813 .61536 L
Mfstroke
.93813 .61536 m
1 .625 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
Mistroke
.75005 .74995 L
.75254 .74736 L
.76665 .72996 L
.77841 .71423 L
.7874 .70313 L
.79915 .69099 L
.80653 .68484 L
.81497 .67907 L
.82595 .67332 L
.84154 .66788 L
.86298 .66423 L
.88983 .66393 L
.93462 .67004 L
Mfstroke
.93462 .67004 m
1 .6875 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75003 .74997 L
.75169 .74827 L
.76218 .73653 L
.77185 .72613 L
.77974 .71901 L
.78433 .71553 L
.79055 .71157 L
.79751 .70808 L
.80564 .70508 L
.81652 .70252 L
.83194 .70111 L
.84207 .70126 L
.85529 .70245 L
Mistroke
.88733 .70867 L
.93376 .7231 L
Mfstroke
.93376 .7231 m
1 .75 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
Mistroke
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75002 .74998 L
.75015 .74985 L
.75144 .74853 L
.75386 .74602 L
.75649 .74332 L
.7614 .73869 L
.76468 .73602 L
.76952 .73275 L
.77322 .73078 L
.7774 .72903 L
.78266 .72745 L
.78893 .72632 L
.79616 .72585 L
.80591 .72627 L
.81659 .72781 L
.83177 .73139 L
.85383 .73863 L
.88753 .75269 L
Mfstroke
.88753 .75269 m
1 .8125 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75001 .74999 L
.75009 .74991 L
.75069 .74931 L
.75193 .74808 L
.75519 .7452 L
.75682 .74402 L
.75895 .74277 L
.76048 .74206 L
.76252 .74131 L
.76483 .74071 L
.76746 .7403 L
.77114 .74013 L
.77553 .74039 L
.78182 .74145 L
.78624 .74256 L
.79099 .74402 L
.80322 .74869 L
Mistroke
.82242 .75784 L
.88752 .79674 L
Mfstroke
.88752 .79674 m
1 .875 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75001 .74999 L
.75006 .74994 L
.75038 .74962 L
.75104 .74903 L
.75176 .74849 L
.75243 .74811 L
.75285 .74792 L
.75332 .74775 L
.75396 .74758 L
.75435 .7475 L
.75482 .74744 L
.75576 .74739 L
.75709 .74747 L
.7586 .74771 L
.76071 .74826 L
.76332 .74919 L
.76643 .75054 L
.77822 .75709 L
Mistroke
.80475 .77542 L
Mfstroke
.80475 .77542 m
1 .9375 L
s
.75 .75 m
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.75 .75 L
.89405 .89405 L
s
.89405 .89405 m
1 1 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{46, 0}, {0, 6}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00=_ooool3o`0000Cooooo00?o0000ooooooooool0
0_ooool3o`0001Oooooo0ol0000Hooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o0000
5Oooool2o`0001Sooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000Gooooo`?o0000
5oooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`0001Oooooo1Ol00002ooooo`00=ooo
ool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000005oooool00ol0003ooooo
ooooo`0Fooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Coooo
o`04o`000?ooooooooooo`0001Kooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooo
oooooooo000001Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`07ooooo`05o`00
0?ooooooooooooooool000005oooool01?l0003oooooooooool00002ooooo`00;oooool5o`0000?o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0=ooooo`Go00000oooool00ol0003o
ooooooooo`0?ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo
017ooooo00Co0000oooooooooooo00005_ooool01?l0003oooooooooool0000;ooooo`03o`000?oo
oooooooo01Gooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo01Kooooo00?o0000ooooooooool00_ooool003Oooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0Eooooo`03o`000?oooooooooo01Kooooo00Co0000oooooooooooo00002ooo
ool00ol0003oooooooooo`0Aooooo`04o`000?ooooooooooo`0001Kooooo00Co0000oooooooooooo
00002oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo01Oooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo007ooooo000gooooo`03o`00
0?oooooooooo00Oooooo1?l0000Hooooo`03o`000?oooooooooo01Kooooo00Co0000oooooooooooo
00001oooool4o`0001Cooooo00Co0000oooooooooooo00005_ooool01?l0003oooooooooool00007
ooooo`Co00006?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Oooooo1?l0000G
ooooo`05o`000?ooooooooooooooool000000_ooool003Kooooo0_l00009ooooo`03o`000?oooooo
oooo01Sooooo0_l0000Hooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool05Ooo
ool01?l0003oooooooooool0000Fooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooooooo
ool06?ooool2o`0001Sooooo0_l00009ooooo`03o`000?oooooooooo01Sooooo00Go0000oooooooo
ooooooooo`000002ooooo`00=oooool00ol0003oooooooooo`07ooooo`Go00005oooool00ol0003o
ooooooooo`0Gooooo`;o00002?ooool5o`0001Cooooo0_l0000Hooooo`;o00002?ooool5o`0001Oo
oooo00?o0000ooooooooool05oooool00ol0003oooooooooo`07ooooo`Go00005oooool3o`0000?o
oooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo000Koooooooo
00000ol00003ooooo`006oooool00ooS5`co0000o`00000:o`000003o`:XW_l0003o000000[o0000
00?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o0000
00?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo0000
00?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000Go`000003o`:XW_l0003o000000[o0000
00?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000006o`000004on<G3?l0003o0000o`:XWPco
000000?o0ZRNon<G3?l000002_l000001?l2Z9ko0000o`000?oS5``9o`000003o`:XW_l0003o0000
00?o000000?ohaL<o`000?l000001?l000000ol2Z9ko0000o`000007o`000004on<G3?l0003o0000
o`:XWPgo00000oooool001_ooooo00?o0000on<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcV
f@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
haL<00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN2_o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Wo
haL<00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_oS
5`coc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G
3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2on<G30;oc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T2o`0000?ooooo000Kooooo`04o`000?o<i]Woc>KIon<G337oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_o<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
1_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?ohaL<olcVfOo<i]T02_o<i]T01?l2Z9ko
c>KIolcVfOoS5``@olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T02Oo<i]T2o`00
00?ooooo000Kooooo`05o`000?o<i]Woc>KIolcVfOoS5``0Noo<i]T00ol0003oc>KIolcVf@0^olcV
f@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0>olcV
f@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T02?o<i]T2o`0000?ooooo000Kooooo`03
o`000?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T0N?o<i]T00ol0003oc>KIolcVf@0_olcVf@03
on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0=olcVf@03
on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T02?o<i]T2o`0000?ooooo000Kooooo`03o`00
0?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0Moo<i]T00ol0003oc>KIolcVf@0_olcVf@03on<G
3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G
3?o<i]Woc>KI00koc>KI0_oS5``8olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T01?o<
i]T00ooS5`coc>KIolcVf@1folcVf@03o`000?o<i]Woc>KI02ooc>KI00?ohaL<olcVfOo<i]T03_o<
i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<
i]T00ooS5`coc>KIolcVf@06olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T01Oo<i]T0
0ooS5`coc>KIolcVf@1eolcVf@03o`000?o<i]Woc>KI033oc>KI00?ohaL<olcVfOo<i]T03_o<i]T0
0ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<i]T2
on<G30Koc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI
01Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_oS5`coc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?ohaL<olcVfOl2Z9h03oo<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI
00?oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00?o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co0ZRNolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcV
fOoS5``02?o<i]T00ol2Z9koc>KIolcVf@06olcVf@04on<G3?o<i]Woc>KIolcVf@;o0ZRN0_l00003
ooooo`006oooool00ol0003oc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G
3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcV
fOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0;olcVf@04o`:XW_o<i]Woc>KIolcVf@;ohaL<1oo<i]T0
0ol2Z9koc>KIolcVf@06olcVf@;ohaL<0oo<i]T00ol2Z9ko0000ooooo`02ooooo`006oooool00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@05olcVf@GoTB6N00?o0000oi4QW_nA8Ih01?nA8Ih6olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?ohaL<olcVfOl2Z9h02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI
00Goc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@02o`0000?ooooo000Kooooo`03
o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_nA8IkoTB6N00GoTB6N1Oo<i]T00ol0003oc>KIolcVf@04olcVf@KoTB6N00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ooS5`co0ZRNolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2
Z9koc>KIolcVf@06olcVf@;ohaL<00?oc>KIo`000?l000000oooool001_ooooo00?o0000o`:XW_o<
i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0onA8Ih<olcVf@03
o`000?o<i]Woc>KI00[oc>KI0onA8Ih:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<
i]T01?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00_oc>KI00Co0ZRNolcVfOo<
i]Woc>KI0_oS5``7olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<o`000?l000000oooool001_o
oooo00?o0000olcVfOl2Z9h03?o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Go
c>KI0_nA8Ih2olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@03oi4QWPOoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03
on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS5`co0000ooooo`02ooooo`00
6oooool2on<G30koc>KI00?ohaL<olcVfOo<i]T0;_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@02olcVf@?oTB6N
1?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
0oo<i]T3oi4QWPCoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G
3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G
3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T03oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<
i]WohaL<00koc>KI00?ohaL<olcVfOo<i]T0E_o<i]T2oi4QWQCoc>KI00?o0000olcVfOo<i]T04oo<
i]T2oi4QWQgoc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<
i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T03_o<i]T2o`0000?ooooo000Kooooo`04o`000?o<i]Wo
c>KIon<G30koc>KI00?ohaL<olcVfOo<i]T0Doo<i]T2oi4QWQKoc>KI00?o0000olcVfOo<i]T05Oo<
i]T2oi4QWQcoc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<
i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T03Oo<i]T2o`0000?ooooo000Kooooo`05o`000?o<i]Wo
c>KIolcVfOoS5``03_o<i]T00ooS5`coc>KIolcVf@1?olcVf@?oTB6N6?o<i]T00ol0003oc>KIolcV
f@0GolcVf@;oTB6N6_o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI017oc>KI00?o
haL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0<olcVf@;o00000oooool001_ooooo00?o0000
olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI04coc>KI0_nA8IhK
olcVf@03o`000?o<i]Woc>KI01Woc>KI0_nA8IhHolcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<
olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI00_oc>KI0_l00003
ooooo`006oooool00ol0003oc>KIolcVf@03olcVf@;ohaL<3Oo<i]T00ooS5`coc>KIolcVf@1:olcV
f@03oi4QW_o<i]Woc>KI01_oc>KI00?o0000olcVfOo<i]T06oo<i]T00onA8Ikoc>KIolcVf@0FolcV
f@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0AolcV
f@;ohaL<2oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<
i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01Oo<i]T00onA8Ikoc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T00_o<i]T00onA8Ikoc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<
i]Woc>KIon<G3007olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T02?o<i]T2o`00
00?ooooo000Kooooo`03o`000?o<i]Woc>KI00Koc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ooS5`co
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T2oi4QWPKo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9koc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@03olcVf@;oTB6N1?o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``01oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01?oS5`coc>KIolcVfOl2Z9h<
olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T2o`:XWP;o00000oooool0
01_ooooo00?o0000olcVfOo<i]T01oo<i]T00ooS5`co0ZRNolcVf@0;olcVf@03on<G3?o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@02olcVf@03oi4QW_o<i]Woc>KI
00Koc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9koc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@05oi4QW_o<i]Woc>KI
olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00CohaL<
olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o
0ZRNo`000?ooool00_ooool001_ooooo0_l2Z9h9olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?ohaL<
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@05o`:XW_o<i]Woc>KIolcVfOnA8Ih02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00CoTB6NolcVfOo<i]Wo0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00CohaL<olcVfOo<i]Wo
0ZRN3?o<i]T00ol2Z9koc>KIolcVf@02olcVf@;ohaL<1_o<i]T2o`0000?ooooo000Kooooo`03o`00
0?o<i]Wo0ZRN00Woc>KI0_oS5``<olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIoi4QWP09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T01?nA8Ikoc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcV
fOo<i]T00oo<i]T2o`0000?ooooo000Kooooo`04o`000?o<i]Woc>KIo`:XWP[oc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_nA8Ih:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2oi4QWP03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KI
o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@03olcVf@;o00000oooool0
01_ooooo00?o0000olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00onA8Iko0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00onA8Ikoc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Wo
c>KI00;oc>KI0_oS5``3olcVf@;o00000oooool000Oooooo0ol00004ooooo`03o`000?oooooooooo
00;ooooo0ol00005ooooo`03o`000?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0^olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?oTB6NolcVfOl2Z9h02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?o<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNoi4QW_o<i]T02_o<i]T00ol2
Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS
5`coc>KIolcVf@0ColcVf@;ohaL<00?oc>KIo`000?l000000oooool000Sooooo00?o0000oooooooo
ool01oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000olcVfOo<i]T03_o<i]T00ooS
5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI03Koc>KI00?oTB6NolcVfOo<i]T09_o<i]T00ol0
003oc>KIolcVf@0VolcVf@03oi4QW_o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS
5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<o`000?l000000oooool000Go
00000oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000olcVfOo<
i]T03oo<i]T2on<G30_oc>KI00?ohaL<olcVfOo<i]T0=?o<i]T00onA8Ikoc>KIolcVf@0WolcVf@03
o`000?o<i]Woc>KI02Ooc>KI00?oTB6NolcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0EolcVf@03
on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`co0000ooooo`02ooooo`00
2?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo0_oS5``BolcVf@03on<G
3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T0<_o<i]T00onA8Ikoc>KIolcVf@0XolcVf@03o`00
0?o<i]Woc>KI02Soc>KI00?oTB6NolcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G
3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04oo<i]T2o`0000?ooooo0008ooooo`03o`000?oo
oooooooo00Oooooo1?l00005ooooo`03o`000?o<i]WohaL<01;oc>KI00?ohaL<olcVfOo<i]T02Oo<
i]T00ooS5`coc>KIolcVf@0aolcVf@03oi4QW_o<i]Woc>KI02Soc>KI00?o0000olcVfOo<i]T0:?o<
i]T00onA8Ikoc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05?o<
i]T00ooS5`coc>KIolcVf@0BolcVf@;o00000oooool000Oooooo0_l00009ooooo`03o`000?oooooo
oooo00Kooooo00?o0000olcVfOo<i]T00_oS5``AolcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<
olcVfOo<i]T09oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03oi4QW_o<i]Woc>KI02Woc>KI00?o0000
olcVfOo<i]T0:Oo<i]T00onA8Ikoc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<
olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0EolcVf@;ohaL<4_o<i]T2o`0000?ooooo0008oooo
o`03o`000?oooooooooo00Oooooo1Ol00004ooooo`03o`000?o<i]Woc>KI00;oc>KI00?ohaL<olcV
fOo<i]T03oo<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?oTB6NolcV
fOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T01oo<i]T00ol0003oc>KIolcVf@0=olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03oi4QW_o<i]Woc>KI00?oc>KI00?o0ZRNolcV
fOo<i]T01Oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T0
0ooS5`coc>KIo`:XWP0FolcVf@;ohaL<4?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI
00?oc>KI0_oS5``2olcVf@;o0ZRN2oo<i]T00ol2Z9kohaL<on<G300:olcVf@03on<G3?o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00?oc>KI00?oTB6NolcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?l0003oc>KIo`:XW_l2Z9h;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03oi4QW_o<i]Wo
c>KI00;oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0;olcVf@;o0ZRN2_o<i]T00ooS5`co0ZRNo`:X
WP0:olcVf@;o0ZRN00?oc>KIo`000?l000000oooool001_ooooo00?o0000olcVfOo<i]T01Oo<i]T0
1OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNon<G3?o<i]T02Oo<i]T00ooS5`coc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@02olcVf@03oi4QW_o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T01OnA8Ikoc>KIolcV
fOo<i]Wo0ZRN00Soc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0;olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?ohaL<olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00_o
c>KI0_l2Z9h00ol0003oooooooooo`01ooooo`006oooool2o`:XWPOoc>KI0_oS5``2olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WoTB6N00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNo`000?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T01_o<i]T01?nA8Ikoc>KIolcVfOl2Z9h8olcVf@05on<G3?o<i]Woc>KI
olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00coc>KI0_l2Z9h9
olcVf@04on<G3?o<i]Wo0ZRNo`:XWP[oc>KI0_l00003ooooo`006oooool00ol0003oc>KIo`:XWP08
olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNon<G3?o<i]T02Oo<i]T00ooS5`coc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIoi4Q
WP09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Wo000000_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CoTB6NolcVfOo<i]Wo0ZRN1oo<i]T00ooS5`coc>KI
olcVf@02olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KI
o`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_oS5``00oo<i]Wo0ZRNolcVf@08olcVf@;o0000
0oooool001_ooooo00Co0000olcVfOo<i]Wo0ZRN2?o<i]T2on<G3003olcVfOl2Z9koc>KI00_oc>KI
00?o0ZRNon<G3?o<i]T02Oo<i]T00ooS5`coc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koTB6NolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04o`:XW_o<i]Woc>KIo`0000[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?oTB6NolcVfOl2Z9h02?o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOl2Z9h02?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<
i]T03Oo<i]T2on<G30Woc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?oTB6NolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@07olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
oi4QW_l2Z9koc>KI00Ooc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h06?o<i]T2on<G30Soc>KI0_l00003ooooo`00
6oooool00ol0003oc>KIolcVf@0<olcVf@;ohaL<3oo<i]T00ooS5`coc>KIolcVf@07olcVf@03on<G
3?o<i]Woc>KI01ooc>KI00?oTB6No`:XW_o<i]T0<Oo<i]T00ol0003oc>KIolcVf@0aolcVf@03oi4Q
W_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0IolcVf@;ohaL<
1_o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03Oo<
i]T00ooS5`coc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI01koc>KI00?oTB6NolcVfOo<i]T0<Oo<
i]T00ol0003oc>KIolcVf@0bolcVf@03oi4QW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T07?o<
i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI00?oc>KI0_l00003ooooo`006oooool0
0ol0003oc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T01oo<i]T0
0ooS5`coc>KIolcVf@0LolcVf@03oi4QW_o<i]Woc>KI03;oc>KI00?o0000olcVfOo<i]T0<oo<i]T0
0onA8Ikoc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T06_o<i]T2
on<G30?oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0@olcVf@;ohaL<3_o<i]T00ooS
5`coc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI01_oc>KI00?oTB6NolcVfOo<i]T0<_o<i]T00ol0
003oc>KIolcVf@0colcVf@03oi4QW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T07Oo<i]T2on<G
31coc>KI00?ohaL<olcVfOo<i]T00_l00003ooooo`006oooool00ol0003oc>KIolcVf@0BolcVf@03
on<G3?o<i]Woc>KI00coc>KI0_oS5``8olcVf@03on<G3?o<i]Woc>KI01Woc>KI00?oTB6NolcVfOo<
i]T0<oo<i]T00ol0003oc>KIolcVf@0dolcVf@03oi4QW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<
i]T07_o<i]T00ooS5`coc>KIolcVf@0JolcVf@;ohaL<0_l00003ooooo`006oooool00ol0003oc>KI
olcVf@0ColcVf@;ohaL<3_o<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00coc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00onA8Ikoc>KIolcVf@0dolcVf@03o`000?o<i]Woc>KI03Coc>KI
00?oTB6NolcVfOo<i]T01Oo<i]T00ol2Z9kohaL<olcVf@0PolcVf@;ohaL<7?o<i]T00ooS5`co0000
ooooo`02ooooo`006oooool2on<G31Koc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcV
f@06olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00onA8Ikoc>KIolcV
f@03olcVf@03o`:XW_o<i]Woc>KI02koc>KI00?o0000olcVfOo<i]T0<_o<i]T01?l2Z9koc>KIolcV
fOnA8Ih6olcVf@03o`:XW_oS5`coc>KI00Woc>KI00?o0ZRNolcVfOo<i]T05_o<i]T00ooS5`coc>KI
olcVf@0IolcVf@;o00000oooool001_ooooo00Co0000olcVfOoS5`cohaL<1Oo<i]T2o`:XWP_oc>KI
0_l2Z9h00oo<i]WohaL<on<G3008olcVf@;o0ZRN0oo<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G
3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00onA8Ikoc>KIolcVf@04olcVf@03o`:X
W_o<i]Woc>KI02koc>KI00?o0000olcVfOo<i]T0<_o<i]T01Ol2Z9koc>KIolcVfOo<i]WoTB6N00Ko
c>KI00?o0ZRNon<G3?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T00ol2Z9ko
haL<on<G300:olcVf@;o0ZRN2_o<i]T2o`:XWP03olcVfOl0003o000000?ooooo000Kooooo`04o`00
0?o<i]Woc>KIolcVf@;ohaL<1Oo<i]T2o`:XWP_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T01Ol2
Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@05
olcVf@03oi4QW_o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T3o`:XWPWoc>KI1?l2Z9hE
olcVf@03o`000?o<i]Woc>KI01Ooc>KI1?l2Z9h:olcVf@?o0ZRN2Oo<i]T00ol2Z9koc>KIolcVf@02
olcVf@03oi4QW_o<i]Woc>KI00Coc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@;o0ZRN00?o0000ooooooooool00Oooool001_ooooo0_l2Z9h4olcVf@;ohaL<1Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@;o0ZRN00?oc>KIon<G3?oS5``02?o<i]T2o`:XWP;oc>KI0_oS5``7olcV
f@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00onA8Ikoc>KIolcVf@03olcV
f@03o`:XW_o<i]Woc>KI00Soc>KI0ol2Z9h8olcVf@Co0ZRN2Oo<i]T@odJ2]003o`000?m6P[CoAX:d
00ooAX:d1?o<i]T4o`:XWP_oc>KI0ol2Z9h<olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?oTB6NolcV
fOo<i]T01?o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcV
f@03o`:XW_oS5`cohaL<00[oc>KI0_l2Z9h:olcVf@;o00000oooool001_ooooo00?o0000olcVfOl2
Z9h01Oo<i]T2on<G30Coc>KI0_l2Z9h;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00Go0ZRNolcV
fOo<i]Woc>KIon<G3007olcVf@03on<G3?l2Z9koc>KI00Woc>KI00?o0ZRNolcVfOo<i]T00oo<i]T0
0onA8Ikoc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l2Z9h@olcVf@SoAX:d4?o<i]T0
0ol0003oc>KIolcVf@0?olcVf@SoAX:d2Oo<i]T2o`:XWPkoc>KI00?o0ZRNolcVfOo<i]T01?o<i]T0
0onA8Ikoc>KIolcVf@04olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2
o`0000?ooooo000Kooooo`04o`000?o<i]Woc>KIo`:XWPKoc>KI0_oS5``4olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T00_oS5``8olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``01oo<
i]T00ooS5`co0ZRNolcVf@08olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?oTB6NolcVfOo<i]T01?o<
i]T00ol2Z9koc>KIolcVf@0<olcVfAWohaL<3?o<i]T00ol0003oc>KIolcVf@0GolcVf@GoAX:d5?o<
i]T00ol2Z9koc>KIolcVf@05olcVf@03oi4QW_o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOoS5``03?o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?oS5``02_o<
i]T00ol2Z9koc>KIolcVf@06olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T02Oo<i]T2
on<G31?oc>KI0_oS5``;olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T02?o<i]T0
1Ol2Z9koc>KIolcVfOo<i]WoTB6N00Goc>KI00?o0ZRNolcVfOo<i]T01_o<i]T7on<G30;oc>KI1Om6
P[@BolcVf@GohaL<1oo<i]T00ol0003oc>KIolcVf@0LolcVf@GoAX:d3_o<i]T00ol2Z9koc>KIolcV
f@06olcVf@03oi4QW_o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOoS5``0:?o<i]T2on<G317oc>KI0_l0
0003ooooo`006oooool00ol0003oc>KIolcVf@0;olcVf@;ohaL<4oo<i]T00ooS5`coc>KIolcVf@09
olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T02_o<i]T00onA8Ikoc>KIolcVf@08
olcVf@GohaL<1?o<i]T5odJ2]1coc>KI1OoS5``2olcVf@03o`000?o<i]Woc>KI027oc>KI1Om6P[@C
olcVf@03oi4QW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T0:?o<i]T2on<G30ooc>KI0_l00003
ooooo`006oooool00ol0003oc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI017oc>KI0_oS5``:olcV
f@;ohaL<1_o<i]T00ooS5`coc>KIolcVf@09olcVf@03oi4QW_o<i]Woc>KI00Goc>KI0ooS5``2olcV
f@[ohaL<8oo<i]T2on<G3003o`000?oS5`cohaL<02Koc>KI1Om6P[@>olcVf@03oi4QW_o<i]Woc>KI
00Koc>KI00?ohaL<olcVfOo<i]T0:Oo<i]T2on<G30goc>KI0_l00003ooooo`006oooool00ol0003o
c>KIolcVf@0>olcVf@;ohaL<4oo<i]T2on<G30[oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`co
c>KIolcVf@07olcVf@03oi4QW_o<i]Woc>KI00?oc>KI2?oS5``2odJ2]0Soc>KI1OoS5``PolcVf@03
o`000?o<i]Woc>KI00CohaL<9oo<i]T4odJ2]0_oc>KI00?oTB6NolcVfOo<i]T01_o<i]T00ooS5`co
c>KIolcVf@0ZolcVf@;ohaL<2oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI013oc>KI
0_oS5``ColcVf@03on<G3?o<i]Woc>KI00Soc>KI0_oS5``5olcVf@03on<G3?o<i]Woc>KI00Koc>KI
00CoTB6NolcVfOo<i]Woc>KI1OoS5``01?o<i]WoAX:dodJ2]?m6P[@@olcVf@GohaL<6oo<i]T00ol0
003oc>KIolcVf@04olcVf@?ohaL<:?o<i]T3odJ2]0Soc>KI00?oTB6NolcVfOo<i]T01oo<i]T00ooS
5`coc>KIolcVf@0[olcVf@;ohaL<2Oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI01;o
c>KI0_oS5``BolcVf@;ohaL<2_o<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Co
c>KI00?oTB6NolcVfOo<i]T01?oS5``01?o<i]WoAX:dodJ2]?m6P[@HolcVf@CohaL<5oo<i]T00ol0
003oc>KIolcVf@07olcVf@?ohaL<:?o<i]T3odJ2]0Koc>KI00?oTB6NolcVfOo<i]T01oo<i]T2on<G
32goc>KI0_oS5``7olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T05?o<i]T2on<G31;o
c>KI0_oS5``9olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00onA8Iko
c>KIon<G3003olcVf@;oAX:d7oo<i]T3on<G31Coc>KI00?o0000olcVfOo<i]T02_o<i]T3on<G32So
c>KI0_m6P[@4olcVf@03oi4QW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T0;?o<i]T2on<G30Go
c>KI0_l00003ooooo`004oooool3o`0000Gooooo00?o0000olcVfOo<i]T05_o<i]T2on<G31;oc>KI
00?ohaL<olcVfOo<i]T01oo<i]T2on<G30Coc>KI00?ohaL<olcVfOo<i]T00_o<i]T00onA8IkohaL<
on<G3008on<G31ooc>KI0_oS5``BolcVf@03o`000?o<i]Woc>KI00goc>KI0ooS5``WolcVf@;oAX:d
0_o<i]T00onA8Ikoc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI02goc>KI00?ohaL<olcVfOo<i]T0
0_o<i]T2o`0000?ooooo000Dooooo`03o`000?oooooooooo00Cooooo00?o0000olcVfOo<i]T01_o<
i]T2o`:XWP_oc>KI0_l2Z9h3olcVf@;ohaL<1_o<i]T2o`:XWPWoc>KI0_oS5``2o`:XWPOoc>KI00?o
haL<olcVfOo<i]T00_o<i]T00ooS5`co0ZRNo`:XWP03on<G3003odJ2]?o<i]Woc>KI00;oc>KI0_l2
Z9h2olcVf@?ohaL<1_o<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@;ohaL<0_l2Z9h;olcVf@;o0ZRN00?o
c>KIo`000?o<i]T02?o<i]T2o`:XWPOoc>KI0ooS5``2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<
i]T2odJ2]003olcVfOnA8Iko0ZRN00;o0ZRN1oo<i]T2o`:XWP;ohaL<2Oo<i]T2o`:XWP_oc>KI0_l2
Z9h:olcVf@;o0ZRN2_o<i]T2on<G3004o`:XW_o<i]Wo0000o`0000?ooooo000<ooooo`Go00000ooo
ool00ol0003oooooooooo`04ooooo`03o`000?o<i]Woc>KI00Soc>KI0ol2Z9h:olcVf@?o0ZRN0_o<
i]T2on<G30Koc>KI0ol2Z9h8olcVf@;ohaL<0_l2Z9h6olcVf@;ohaL<0oo<i]T3on<G3003odJ2]?o<
i]Woc>KI00Koc>KI0ol2Z9h2olcVf@?ohaL<1Oo<i]T3o`:XWP[oc>KI0ol2Z9h8olcVf@?ohaL<0_l2
Z9h:olcVf@03o`:XW_l0003oc>KI00[oc>KI0_l2Z9h8olcVf@;ohaL<0ol2Z9h:olcVf@?o0ZRN2_o<
i]T3o`:XWPWoc>KI0_m6P[@2olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l2Z9h3on<G30Soc>KI0_l2
Z9h;olcVf@;o0ZRN2_o<i]T3o`:XWPWoc>KI0ooS5``00ol0003oooooooooo`01ooooo`005?ooool0
0ol0003oooooooooo`04ooooo`;ohaL<00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h2
olcVf@;ohaL<1oo<i]T2o`:XWPSoc>KI0ooS5``00ol2Z9koc>KIolcVf@04olcVf@GohaL<00?oc>KI
o`:XW_o<i]T02_o<i]T2o`:XWP?oc>KI0_oS5``6olcVf@;o0ZRN2oo<i]T2o`:XWPWoc>KI0ooS5``0
0ol2Z9koc>KIolcVf@07olcVf@03o`000?l2Z9ko0ZRN00_oc>KI0_l2Z9h8olcVf@;ohaL<00?oc>KI
o`:XW_l2Z9h02oo<i]T2o`:XWP_oc>KI0_l2Z9h7olcVf@05o`:XW_o<i]WohaL<odJ2]?l2Z9h02oo<
i]T2o`:XWP04olcVfOoS5`cohaL<on<G30Ooc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWPWoc>KI
0_l00003ooooo`005?ooool00ol0003oooooooooo`04ooooo`03o`000?o<i]WohaL<00;ohaL<2oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:XW_o<i]Woc>KIolcVf@?ohaL<1_o<i]T00ol2Z9koc>KI
olcVf@08olcVf@03on<G3?l2Z9koc>KI00Goc>KI00?oAX:don<G3?oS5``00_oS5``>olcVf@03o`:X
W_o<i]Woc>KI00;oc>KI0_oS5``6olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T2on<G30Soc>KI00Co0000olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@07olcVf@?o
haL<00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Go
c>KI00?o0ZRNoi4QW_l2Z9h00_m6P[@<olcVf@04o`:XW_o<i]Woc>KIolcVf@;ohaL<1oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`00
00?ooooo000Cooooo`;o00001_ooool00ol0003oc>KIolcVf@02olcVf@;ohaL<7Oo<i]T2on<G313o
c>KI2_oS5``2olcVf@03on<G3?o<i]Woc>KI01;oc>KI0_oS5``OolcVf@;ohaL<1_o<i]T00ol0003o
c>KIolcVf@0JolcVf@;ohaL<8_o<i]T00onA8Ikoc>KIolcVf@03odJ2]0ooc>KI0_oS5``XolcVf@;o
00000oooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oc>KIolcVf@04olcVf@?ohaL<
7?o<i]T2on<G313oc>KI0_m6P[@2olcVf@?ohaL<00GoTB6NolcVfOo<i]Woc>KIon<G300EolcVf@;o
haL<7oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`000?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<
i]T07oo<i]T00onA8Ikoc>KIolcVf@03olcVf@;oAX:d3oo<i]T2on<G32Koc>KI0_l00003ooooo`00
6oooool00ol0003oc>KIolcVf@07olcVf@;ohaL<7?o<i]T3on<G30_oc>KI0_m6P[@3olcVf@?ohaL<
00?oc>KIoi4QW_o<i]T00oo<i]T00ooS5`coc>KIolcVf@0DolcVf@;ohaL<7_o<i]T2on<G30?oc>KI
00?o0000olcVfOo<i]T07Oo<i]T2on<G323oc>KI00?oTB6NolcVfOo<i]T01?o<i]T2odJ2]0ooc>KI
0ooS5``SolcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T02Oo<i]T2on<G31goc>KI1ooS
5``2olcVf@;oAX:d00?oc>KIon<G3?oS5``01OoS5``00onA8Ikoc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI01Goc>KI0_oS5``NolcVf@;ohaL<00?oc>KIo`000?o<i]T08?o<i]T2on<G31koc>KI00?o
TB6NolcVfOo<i]T01_o<i]T2odJ2]13oc>KI1?oS5``OolcVf@;o00000oooool001_ooooo00?o0000
olcVfOo<i]T02oo<i]T3on<G327oc>KI1OoS5``3olcVf@CohaL<00?oTB6NolcVfOo<i]T01Oo<i]T0
0ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<o`000?o<i]T08_o<i]T0
0ooS5`coc>KIolcVf@0LolcVf@03oi4QW_o<i]Woc>KI00Ooc>KI0_m6P[@BolcVf@CohaL<6oo<i]T2
o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00koc>KI0ooS5``MolcVf@;oAX:d1Oo<i]T4on<G
3003olcVfOoS5`coc>KI00Soc>KI00?ohaL<olcVfOo<i]T05_o<i]T2on<G31koc>KI00?o0000on<G
3?oS5``08_o<i]T2on<G31coc>KI00?oTB6NolcVfOo<i]T02Oo<i]T2odJ2]1Coc>KI0ooS5``HolcV
f@;o00000oooool001_ooooo00?o0000olcVfOo<i]T04Oo<i]T3on<G31Soc>KI0_m6P[@6olcVf@Go
haL<00?oc>KIon<G3?o<i]T02Oo<i]T00ooS5`coc>KIolcVf@0GolcVf@;ohaL<7?o<i]T01?l0003o
c>KIolcVfOoS5``SolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?oTB6NolcVfOo<i]T02_o<i]T00om6
P[Coc>KIolcVf@0DolcVf@?ohaL<5Oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI01Co
c>KI0ooS5``DolcVf@03odJ2]?o<i]Woc>KI00Coc>KI0ooS5``01oo<i]WohaL<on<G3?oS5`coc>KI
on<G3?l2Z9h02_o<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G3?o<i]Woc>KI01Woc>KI00Co0000
olcVfOo<i]Woc>KI0_oS5``RolcVf@;ohaL<5Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03oi4QW_o<
i]Woc>KI00_oc>KI0_m6P[@GolcVf@?ohaL<4_o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Wo
c>KI01Ooc>KI1?oS5``?olcVf@03odJ2]?o<i]Woc>KI00?oc>KI0_oS5``00oo<i]WohaL<olcVf@03
on<G3004olcVfOnA8IkohaL<o`:XWP_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_oS5`coc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN00?oc>KIo`000?o<i]T01?o<
i]T2on<G30;oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03oi4QW_o<
i]Woc>KI00coc>KI00?oAX:dolcVfOo<i]T05oo<i]T3on<G30ooc>KI0_l00003ooooo`006oooool0
0ol0003oc>KIolcVf@06olcVf@;o0ZRN4oo<i]T5on<G30Woc>KI00?oAX:dolcVfOo<i]T00_o<i]T2
on<G30;oc>KI00?ohaL<o`:XW_oS5``00ooS5``01Oo<i]WoTB6Non<G3?o<i]Wo0ZRN00_oc>KI00?o
haL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000olcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h0
3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00?oc>KI0_oS5``5olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00onA8Ikoc>KIolcVf@07olcVf@;o0ZRN
1?o<i]T00om6P[Coc>KIolcVf@0HolcVf@04o`:XW_oS5`cohaL<on<G30Woc>KI0ol2Z9h2o`0000?o
oooo000Kooooo`;o0ZRN2Oo<i]T3o`:XWPSoc>KI1Ol2Z9h8olcVf@kohaL<0_o<i]T00ol2Z9kohaL<
olcVf@04on<G3006olcVfOnA8Ikoc>KIolcVfOoS5`co0ZRN3?o<i]T00ooS5`coc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`000?o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00onA8Ikoc>KIolcVf@05olcVf@;o0ZRN1oo<i]T2
odJ2]0?o0ZRN2?o<i]T5o`:XWP[oc>KI0_l2Z9h4on<G30Soc>KI00?o0ZRNo`000?ooool00_ooool0
01_ooooo00?o0000olcVfOl2Z9h02oo<i]T2o`:XWP_oc>KI0ol2Z9h:olcVf@03o`:XW_m6P[Co0ZRN
00Koc>KI0_l2Z9h00ooS5`coc>KIon<G3004on<G3007olcVfOnA8Ikoc>KIolcVfOoS5`coc>KIo`:X
WP0<olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<on<G
300:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_o<i]T01oo<i]T2on<G30;oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?o
haL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?o
TB6NolcVfOo<i]T00_o<i]T2o`:XWP_oc>KI00?oAX:dolcVfOo<i]T01?l2Z9h9olcVf@?o0ZRN2_o<
i]T2o`:XWP04olcVfOoS5`cohaL<on<G30Goc>KI0_l00003ooooo`006oooool01?l0003oc>KIolcV
fOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI01Goc>KI00?oAX:dolcVfOo<i]T01Oo<i]T01?l2Z9koc>KI
on<G3?o<i]T6on<G3003olcVfOnA8Ikoc>KI00;oc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ooS5`co
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9ko
c>KIolcVf@08olcVf@03o`000?o<i]Wo0ZRN00Woc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00GoTB6NolcVfOo<i]Woc>KIo`:XWP0>
olcVf@03odJ2]?o<i]Woc>KI01_oc>KI00Co0ZRNolcVfOo<i]Woc>KI0ooS5``2olcVf@;o00000ooo
ool001_ooooo00?o0000olcVfOo<i]T09?o<i]T00om6P[Coc>KIolcVf@07olcVf@WohaL<00?oTB6N
olcVfOo<i]T00_o<i]T00ooS5`co0ZRNolcVf@0=olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Co0000
olcVfOo<i]Wo0ZRN2Oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
00?o0ZRNolcVfOo<i]T00_o<i]T00onA8Ikoc>KIolcVf@0AolcVf@03odJ2]?o<i]Woc>KI027oc>KI
0ooS5``00ol0003oooooooooo`01ooooo`006oooool3on<G32;oc>KI0_m6P[@9olcVf@;ohaL<00?o
c>KIon<G3?o<i]T00ooS5``00oo<i]WohaL<oi4QWP04olcVf@03on<G3?o<i]Wo0ZRN00koc>KI00?o
haL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03o`000?o<i]Woc>KI00_oc>KI0_oS
5``PolcVf@03on<G3?o<i]Woc>KI00ooc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00onA8Ikoc>KIolcV
f@0AolcVf@03odJ2]?o<i]Woc>KI02;oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@04
on<G31goc>KI00?oAX:dolcVfOo<i]T02?o<i]T2on<G3003olcVfOoS5`coc>KI00CohaL<00?oc>KI
on<G3?nA8Ih01Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<
olcVfOo<i]T04?o<i]T00ol0003oc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<
olcVfOo<i]T04oo<i]T00onA8Ikoc>KIolcVf@0BolcVf@03odJ2]?o<i]Woc>KI027oc>KI0_l00003
ooooo`006oooool00ol0003oc>KIolcVf@04olcVf@CohaL<6?o<i]T00om6P[Coc>KIolcVf@08olcV
f@;ohaL<0_o<i]T4on<G3004olcVfOoS5`coc>KIon<G30Koc>KI00?ohaL<olcVfOo<i]T03oo<i]T0
0ooS5`coc>KIolcVf@0IolcVf@;ohaL<4?o<i]T00ol0003oc>KIolcVf@0>olcVf@03on<G3?o<i]Wo
c>KI01koc>KI00?ohaL<olcVfOo<i]T04_o<i]T00onA8Ikoc>KIolcVf@0ColcVf@03odJ2]?o<i]Wo
c>KI023oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@08olcVf@CohaL<4oo<i]T00om6
P[Coc>KIolcVf@08olcVf@;ohaL<0_o<i]T02OoS5`coc>KIon<G3?o<i]WohaL<olcVfOoS5`coc>KI
on<G3006olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KI
olcVf@0=olcVf@03o`000?o<i]Woc>KI00ooc>KI0_oS5``OolcVf@03on<G3?o<i]Woc>KI017oc>KI
00?oTB6NolcVfOo<i]T05?o<i]T00om6P[Coc>KIolcVf@0OolcVf@;o00000oooool001_ooooo00?o
0000olcVfOo<i]T03?o<i]T5on<G30goc>KI00?oAX:dolcVfOo<i]T01Oo<i]T4on<G30?oc>KI00?o
haL<olcVfOoS5``00_oS5``2olcVf@03on<G3?o<i]WohaL<00Ooc>KI00?ohaL<olcVfOo<i]T04?o<
i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T04Oo<
i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI01;oc>KI00?oTB6NolcVfOo<i]T05?o<
i]T00om6P[Coc>KIolcVf@0NolcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T04Oo<i]T5
on<G30Ooc>KI00?oAX:dolcVfOo<i]T00_o<i]T4on<G30;oc>KI00GohaL<olcVfOo<i]Woc>KIon<G
3002olcVf@08on<G3?o<i]WohaL<olcVfOoS5`coc>KIoi4QW_oS5``7olcVf@03on<G3?o<i]Woc>KI
017oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI
01;oc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03oi4QW_o<i]Woc>KI
01Goc>KI00?oAX:dolcVfOo<i]T07Oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI01Ko
c>KI3?oS5``5olcVf@05on<G3?o<i]Woc>KIolcVfOoS5``00_o<i]T02OoS5`coc>KIolcVfOoS5`co
c>KIon<G3?o<i]WoTB6Non<G3004olcVf@04o`:XW_o<i]Woc>KIon<G31Coc>KI00?ohaL<olcVfOo<
i]T06_o<i]T2on<G30_oc>KI00?o0000olcVfOo<i]T04oo<i]T2on<G31goc>KI00?ohaL<olcVfOo<
i]T01oo<i]T00ol2Z9koc>KIolcVf@06olcVf@03oi4QW_o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<
i]T03oo<i]T00om6P[Coc>KIolcVf@0MolcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T0
7?o<i]T00om6P[Coc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00;oc>KI00cohaL<olcVfOoS5`co
haL<olcVfOoS5`co0ZRNolcVfOoS5`coc>KIoi4QW_oS5``4olcVf@05o`:XW_o<i]Woc>KIolcVfOoS
5``01oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Ooc>KI0_l2Z9h00oo<i]Wo0000olcVf@08olcV
f@;o0ZRN2oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?oTB6NolcV
fOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0@olcVf@03odJ2]?o<i]Woc>KI01coc>KI0_l00003oooo
o`006oooool00ol0003oc>KIolcVf@0KolcVf@03odJ2]?o<i]Woc>KI00Ooc>KI00?ohaL<o`:XW_l2
Z9h00_o<i]T01?oS5`coc>KIon<G3?oS5``2olcVf@07on<G3?l2Z9koc>KIon<G3?o<i]WoTB6Non<G
3005olcVf@04o`:XW_o<i]Woc>KIon<G30Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03
o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI
00Goc>KI00?oTB6NolcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@;o0ZRN1?o<i]T00om6
P[Coc>KIolcVf@0HolcVf@?o0ZRN0_l00003ooooo`006oooool3o`:XWPKoc>KI1Ol2Z9h8olcVf@Oo
0ZRN00?oAX:dolcVfOo<i]T01Oo<i]T2o`:XWP03on<G3?o<i]Woc>KI00;oc>KI00CohaL<olcVfOoS
5`cohaL<0_o<i]T02?oS5`co0ZRNolcVfOo<i]WohaL<oi4QW_o<i]WohaL<1Oo<i]T01Ol2Z9koc>KI
olcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`000?o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GoTB6N
olcVfOo<i]Woc>KIo`:XWP0;olcVf@?o0ZRN1oo<i]T00om6P[Co0ZRNo`:XWP05o`:XWPGoc>KI1Ol2
Z9h;olcVf@03o`:XW_l0003ooooo00;ooooo000Kooooo`04o`000?o<i]Woc>KIo`:XWP[oc>KI0ol2
Z9h;olcVf@03odJ2]?o<i]Woc>KI00Coc>KI0_l2Z9h00oo<i]WohaL<olcVf@03olcVf@05on<G3?o<
i]WohaL<olcVfOoS5``00_o<i]T02?oS5`co0ZRNolcVfOo<i]WohaL<oi4QW_o<i]WohaL<1_o<i]T0
1Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3007olcVf@03o`00
0?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00Go
c>KI00GoTB6NolcVfOo<i]Woc>KIo`:XWP09olcVf@;o0ZRN2oo<i]T00om6P[Coc>KIolcVf@0>olcV
f@?o0ZRN2?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI01Soc>KI00?oAX:dolcVfOo<
i]T01oo<i]T00ooS5`coc>KIolcVf@03olcVf@;ohaL<00Ooc>KIon<G3?o<i]Woc>KIon<G3?o<i]Wo
0ZRN00;oc>KI00CohaL<oi4QW_o<i]WohaL<1_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00Co0ZRNolcVfOo<i]Woc>KI0_oS5``5olcVf@03o`000?o<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<
i]Woc>KIon<G3007olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00GoTB6NolcVfOo<i]Woc>KIo`:XWP0G
olcVf@03odJ2]?o<i]Woc>KI01Soc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0HolcV
f@03odJ2]?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00oo<i]T2on<G3003olcVfOoS5`coc>KI
00;oc>KI00WohaL<o`:XW_o<i]Woc>KIon<G3?o<i]WoTB6NolcVfOoS5``01_o<i]T00ol2Z9koc>KI
olcVf@02olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KI
olcVf@02olcVf@04o`000?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<1oo<i]T00ol2
Z9koc>KIolcVf@05olcVf@04oi4QW_o<i]Woc>KIo`:XWQKoc>KI2OoS5``DolcVf@;o00000oooool0
00Sooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?o<i]Woc>KI
01Ooc>KI00?oAX:dolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@03olcVf@;ohaL<0_o<i]T01_oS
5`coc>KIolcVfOoS5`coc>KIo`:XWP;oc>KI00?ohaL<olcVfOnA8Ih00_o<i]T00ooS5`coc>KIolcV
f@04olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcV
f@0LolcVf@05on<G3?o<i]Woc>KIolcVfOl000007?o<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G
3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T01?o<i]T01?nA8Ikoc>KIolcVfOl2Z9hAolcVf@Go
haL<0oo<i]T00om6P[Coc>KIolcVf@03olcVf@SohaL<3?o<i]T2o`0000?ooooo0007ooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?o<i]Woc>KI
01Koc>KI00?oAX:dolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@;ohaL<0oo<i]T01OoS
5`coc>KIolcVfOo<i]WohaL<00Coc>KI00?ohaL<oi4QW_o<i]T00_o<i]T00ooS5`coc>KIolcVf@09
olcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T07?o<i]T01?oS5`coc>KIolcVfOl0
000MolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T03?o<i]T00onA8Ikoc>KIolcV
f@0>olcVf@?ohaL<2Oo<i]T00om6P[Coc>KIolcVf@0:olcVf@KohaL<1_o<i]T2o`0000?ooooo0005
o`0000;ooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`02ooooo`03o`000?o<
i]Woc>KI01Goc>KI00?oAX:dolcVfOo<i]T01_o<i]T01?oS5`coc>KIolcVfOo<i]T3on<G30?oc>KI
00GohaL<olcVfOo<i]Woc>KIon<G3005olcVf@03on<G3?nA8Ikoc>KI00;oc>KI00?ohaL<olcVfOo<
i]T02_o<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOl0
00007_o<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI00_oc>KI00?oTB6NolcVfOo<
i]T02oo<i]T3on<G30goc>KI00?oAX:dolcVfOo<i]T03oo<i]T5on<G3003olcVfOl0003o000000?o
oooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool00_ooool5on<G31;o
c>KI00?oAX:dolcVfOo<i]T01_o<i]T00ooS5`coc>KIon<G3002on<G30;oc>KI00GohaL<olcVfOo<
i]Woc>KIon<G3003olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?ohaL<oi4QW_o<i]T00_o<i]T00ooS
5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS
5`co0000olcVf@0NolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T02oo<i]T00onA
8Ikoc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?oAX:dolcVfOo<i]T04oo<i]T2on<G
3003o`000?oooooooooo007ooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo1?l00005oooo
o`03o`000?o<i]Woc>KI00;oc>KI1ooS5``:olcVf@03odJ2]?o<i]Woc>KI00Coc>KI1OoS5``4olcV
f@05on<G3?o<i]Woc>KIolcVfOoS5``00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?nA8Iko
c>KI00;oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Wo
c>KI01coc>KI00?o0000on<G3?o<i]T07_o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?oTB6NolcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03odJ2]?o<i]Wo
c>KI01?oc>KI0_l00003ooooo`001oooool01?l0003oooooooooool00007ooooo`03o`000?oooooo
oooo00Kooooo00?o0000olcVfOo<i]T02Oo<i]TAon<G3003olcVfOoS5`coc>KI00Goc>KI00GohaL<
olcVfOo<i]Woc>KIon<G3003olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<oi4QW_o<i]T00oo<
i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T06oo<
i]T00ol0003oc>KIon<G300OolcVf@03on<G3?o<i]Woc>KI01Soc>KI00?ohaL<olcVfOo<i]T02_o<
i]T00onA8Ikoc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI01?oc>KI00?oAX:dolcVfOo<i]T04_o<
i]T2o`0000?ooooo0008ooooo`;o00002?ooool5o`0000Cooooo00?o0000olcVfOo<i]T04_o<i]T0
0om6P[Coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00_o<i]T0
1OoS5`coc>KIolcVfOo<i]WohaL<00Goc>KI00?o0ZRNolcVfOoS5``01Oo<i]T01?oS5`coc>KIolcV
fOl2Z9h;olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KI
olcVf@0JolcVf@04o`000?o<i]Woc>KIon<G31ooc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00[oc>KI00CoTB6NolcVfOo<i]Wo0ZRN1_o<i]T00ooS
5`coc>KIolcVf@0ColcVf@03odJ2]?o<i]Woc>KI01;oc>KI0_l00003ooooo`006oooool00ol0003o
c>KIolcVf@0AolcVf@03odJ2]?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`co
c>KIolcVf@02olcVf@05on<G3?l2Z9koc>KIolcVfOoS5``01_o<i]T00ol2Z9koc>KIon<G3005olcV
f@04on<G3?o<i]Woc>KIo`:XWP_oc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP03olcVfOl0003o
c>KI00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02_o<i]T0
1?nA8Ikoc>KIolcVfOl2Z9h5olcVf@03on<G3?o<i]Woc>KI00Goc>KI0_l2Z9h>olcVf@03odJ2]?o<
i]Woc>KI017oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0AolcVf@03odJ2]?o<i]Wo
c>KI00Coc>KI00?ohaL<olcVfOo<i]T01Oo<i]T01OoS5`coc>KIolcVfOo<i]WohaL<00?oc>KI00?o
haL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIon<G3005olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h0
2oo<i]T00ooS5`co0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003oc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00[oc>KI00CoTB6NolcVfOo<i]Wo
0ZRN1?o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00koc>KI00?oAX:dolcVfOo<
i]T03_o<i]T00ol2Z9koc>KIolcVf@02o`0000?ooooo000Kooooo`?o0ZRN1_o<i]T8o`:XWP;oc>KI
00?oAX:dolcVfOo<i]T01?o<i]T01?oS5`co0ZRNo`:XW_l2Z9h4olcVf@03on<G3?o<i]Woc>KI00;o
0ZRN00CohaL<olcVfOo<i]WohaL<2?o<i]T00ol2Z9koc>KIon<G3006olcVf@04on<G3?o<i]Woc>KI
o`:XWPcoc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@02olcVf@03on<G3?o<i]Wo
c>KI00Goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co0ZRNolcVf@09olcVf@04oi4QW_o<i]Wo
c>KIo`:XWP?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T2o`:XWPcoc>KI1?l2Z9h2olcVf@03odJ2]?o<
i]Woc>KI00So0ZRN1Oo<i]T4o`:XWP03o`000?oooooooooo007ooooo000Kooooo`04o`000?o<i]Wo
c>KIo`:XWPooc>KI00?oAX:dolcVfOo<i]T00ol2Z9h00ooS5`coc>KIolcVf@05olcVf@06on<G3?o<
i]Woc>KIo`:XW_o<i]WohaL<0_o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:XW_o<i]WohaL<00Ko
c>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:X
W_o<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOl2Z9h02Oo<i]T00onA8Ikoc>KIo`:XWP04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcV
fOo<i]T02?o<i]T4o`:XWPKoc>KI00?oAX:dolcVfOo<i]T04?o<i]T2o`0000?ooooo000Kooooo`03
o`000?o<i]Woc>KI00ooc>KI00?oAX:dolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@06
on<G3?o<i]Woc>KIo`:XW_o<i]WohaL<0_o<i]T00ooS5`coc>KIolcVf@08olcVf@03o`:XW_nA8Iko
haL<00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o
0000olcVfOl2Z9h01?o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o
haL<o`:XW_o<i]T02Oo<i]T00onA8Iko0ZRNolcVf@03olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o
0ZRNolcVfOo<i]T05?o<i]T00om6P[Coc>KIolcVf@0?olcVf@;o00000oooool001_ooooo00?o0000
olcVfOo<i]T03oo<i]T00om6P[Coc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<
olcVfOo<i]T00oo<i]T00ooS5`coc>KIon<G300;olcVf@03o`:XW_nA8IkohaL<00Ooc>KI00GohaL<
olcVfOo<i]Woc>KIo`:XWP0<olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Co0000olcVfOo<i]Wo0ZRN
1?o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOl2Z9h0
2Oo<i]T00onA8Iko0ZRNolcVf@02olcVf@03on<G3?o<i]Woc>KI01[oc>KI00?oAX:dolcVfOo<i]T0
3oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00koc>KI00?oAX:dolcVfOo<i]T00_o<
i]T00ooS5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOoS5``03?o<
i]T00ol2Z9koTB6Non<G3007olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T06?o<
i]T00ooS5`coc>KIolcVf@0ColcVf@03o`000?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T07_o<
i]T00ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI00Soc>KI00?oTB6No`:XW_o<i]T00_o<
i]T00ooS5`coc>KIolcVf@0KolcVf@03odJ2]?o<i]Woc>KI00koc>KI0_l00003ooooo`006oooool0
0ol0003oc>KIolcVf@0>olcVf@05odJ2]?o<i]Woc>KIolcVfOoS5``02?o<i]T00ooS5`coc>KIolcV
f@02olcVf@?ohaL<3_o<i]T00onA8IkohaL<olcVf@06olcVf@03on<G3?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0BolcVf@03o`000?o<i]Woc>KI00Ooc>KI00?o
haL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI00Soc>KI00?o
TB6NolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@0KolcVf@03odJ2]?o<i]Woc>KI00koc>KI0_l0
0003ooooo`006oooool00ol0003oc>KIolcVf@0=olcVf@05odJ2]?o<i]Woc>KIolcVfOoS5``02?o<
i]T00ooS5`coc>KIolcVf@02olcVf@;ohaL<4?o<i]T00onA8IkohaL<olcVf@07olcVf@03on<G3?o<
i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03o`000?o<
i]Woc>KI00Soc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<
i]Woc>KI00Soc>KI00?oTB6NolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@0LolcVf@03odJ2]?o<
i]Woc>KI00goc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0=olcVf@04odJ2]?o<i]Wo
c>KIon<G30Soc>KI00?ohaL<olcVfOo<i]T00_o<i]T2on<G317oc>KI00?oTB6NolcVfOoS5``01oo<
i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T04?o<
i]T00ol0003oc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T04oo<
i]T00ooS5`coc>KIolcVf@07olcVf@05oi4QW_o<i]Woc>KIolcVfOoS5``07oo<i]T00om6P[Coc>KI
olcVf@0=olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T03Oo<i]T00om6P[Coc>KIon<G
3008olcVf@03on<G3?o<i]Woc>KI00CohaL<4_o<i]T00onA8Ikoc>KIon<G3007olcVf@03on<G3?o<
i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0?olcVf@03o`000?o<
i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<
i]Woc>KI00Ooc>KI00GoTB6NolcVfOo<i]Woc>KIon<G300LolcVf@[ohaL<2Oo<i]T2o`0000?ooooo
000Kooooo`03o`000?o<i]Woc>KI00coc>KI00?oAX:dolcVfOoS5``02?o<i]T4on<G30?oc>KI00?o
haL<olcVfOo<i]T03oo<i]T01?l2Z9koTB6NolcVfOoS5``8olcVf@03on<G3?o<i]Woc>KI017oc>KI
00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03o`000?o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI00Koc>KI
00GoTB6No`:XW_o<i]Woc>KIon<G300EolcVf@OohaL<1?o<i]T00om6P[Coc>KIolcVf@03olcVf@Oo
haL<0_o<i]T2o`0000?ooooo000Kooooo`WohaL<1_o<i]T00om6P[CohaL<olcVf@02olcVf@OohaL<
1Oo<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CoTB6NolcVfOo<i]Wo
haL<1oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00CohaL<olcVfOo<
i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcV
fOl000002Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00Go0ZRN
olcVfOo<i]Woc>KIon<G3009olcVf@04oi4QW_o<i]Woc>KIon<G30coc>KI00?o0ZRNolcVfOo<i]T0
0oo<i]T3on<G30_oc>KI00?oAX:dolcVfOo<i]T02_o<i]T3on<G3003o`000?oooooooooo007ooooo
000Kooooo`03o`000?o<i]Woc>KI00Koc>KI2ooS5``5olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o
haL<olcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04oi4QW_o<i]Woc>KIon<G30Ooc>KI
00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@04on<G3?o<i]Woc>KIo`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo000000[o
c>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0=olcVf@05o`:XW_o<i]Woc>KIolcV
fOoS5``02Oo<i]T01?nA8Ikoc>KIolcVfOoS5``;olcVf@03o`:XW_o<i]Woc>KI00;oc>KI0_oS5``>
olcVf@03odJ2]?o<i]Woc>KI00coc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T00ol2Z9h00oo<i]WohaL<olcVf@07olcV
f@03o`:XW_o<i]Woc>KI00Soc>KI00CoTB6NolcVfOo<i]WohaL<2?o<i]T00ol2Z9kohaL<olcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcV
f@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@04oi4Q
W_o<i]Woc>KIon<G30[oc>KI00Co0ZRNolcVfOo<i]Woc>KI0_oS5``7olcVf@?o0ZRN1oo<i]T00om6
P[Coc>KIolcVf@08olcVf@?o0ZRN0_l00003ooooo`006oooool3o`:XWPKoc>KI1?l2Z9h01?oS5`co
AX:do`:XW_l2Z9h6olcVf@04on<G3?l2Z9ko0ZRNo`:XWP?oc>KI00?ohaL<olcVfOo<i]T01_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@04oi4QW_o<i]Woc>KIon<G30Soc>KI00?o0ZRNon<G3?o<i]T02oo<
i]T00ol2Z9koc>KIolcVf@06olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
0_o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00onA
8Ikoc>KIon<G300:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``01_o<i]T3o`:XWPSoc>KI0_l2Z9h0
0om6P[Co0ZRNo`:XWP03o`:XWPSoc>KI00?o0ZRNo`000?ooool00_ooool001_ooooo00Co0000olcV
fOo<i]Wo0ZRN2?o<i]T00ooS5`coc>KIodJ2]007olcVf@03o`:XW_oS5`coc>KI00Goc>KI00?ohaL<
olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@04oi4QW_o<i]Woc>KIon<G30Woc>KI00?o
0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@09olcVf@03o`000?l2Z9koc>KI00_oc>KI
00Go0ZRNolcVfOo<i]Woc>KIon<G3007olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``01oo<i]T0
0onA8Ikoc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00;ohaL<1Oo<i]T2o`:XWPgoc>KI00?oAX:d
olcVfOo<i]T02oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOm6P[@02?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T01?nA8Ikoc>KIolcVfOoS5``9olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ooS5`coc>KIolcVf@08olcVf@03o`000?o<i]Wo0ZRN00coc>KI00Go0ZRNolcVfOo<i]Woc>KI
on<G3007olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KI
olcVfOl2Z9h;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``01oo<i]T00onA8Ikoc>KIon<G3008olcV
f@04o`:XW_o<i]Woc>KIon<G31Ooc>KI00?oAX:dolcVfOo<i]T02_o<i]T2o`0000?ooooo000Koooo
o`03o`000?o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]WoAX:d1oo<i]T00ooS5`coc>KIolcVf@04
olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T03?o<i]T01?nA8Ikoc>KIolcVfOoS
5``:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcV
fOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@07olcVf@04o`00
0?o<i]Woc>KIo`:XWPcoc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3007olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI00Co0ZRN
olcVfOo<i]WohaL<1oo<i]T00onA8Ikoc>KIon<G3007olcVf@04o`:XW_o<i]Woc>KIon<G31Soc>KI
00?oAX:dolcVfOo<i]T02_o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Koc>KI00Go
haL<olcVfOo<i]Woc>KIodJ2]006olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T0
5?o<i]T01?nA8Ikoc>KIolcVfOoS5``;olcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<
i]T06oo<i]T00ooS5`coc>KIolcVf@06olcVf@03o`000?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<
i]T06oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?oTB6NolcVfOoS
5``02_o<i]T00ooS5`coc>KIolcVf@0FolcVf@03odJ2]?o<i]Woc>KI00[oc>KI0_l00003ooooo`00
6oooool00ol0003oc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?oAX:dolcVfOo<i]T0
0oo<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI01Goc>KI00CoTB6NolcVfOo<i]Wo
haL<3?o<i]T00ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T00ol0003oc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<
i]T03oo<i]T00ooS5`coc>KIolcVf@04olcVf@03oi4QW_o<i]WohaL<00Woc>KI00?ohaL<olcVfOo<
i]T05oo<i]T00om6P[Coc>KIolcVf@0:olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@03olcVf@03odJ2]?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@0FolcVf@05oi4QW_o<i]Woc>KIolcVfOoS5``02oo<i]T00ooS5`co
c>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol0003o
c>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`co
c>KIolcVf@04olcVf@03oi4QW_o<i]WohaL<00Soc>KI00?ohaL<olcVfOo<i]T06?o<i]T00om6P[Co
c>KIolcVf@0:olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T00oo<i]T00ooS5`coc>KI
olcVf@04olcVf@03odJ2]?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KI
olcVf@0FolcVf@05oi4QW_o<i]Woc>KIolcVfOoS5``03?o<i]T00ooS5`coc>KIolcVf@0EolcVf@03
on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol0003oc>KIolcVf@0EolcVf@03
on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@03olcVf@03
oi4QW_o<i]WohaL<00Ooc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00om6P[Coc>KIolcVf@0:olcVf@;o
00000oooool001_ooooo00?o0000olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@04olcVf@03odJ2
]?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@0GolcVf@05oi4Q
W_o<i]Woc>KIolcVfOoS5``03?o<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01_o
c>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01[o
c>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@03olcVf@03oi4QW_o<i]WohaL<00Oo
c>KI00?ohaL<olcVfOo<i]T06_o<i]T00om6P[Coc>KIolcVf@09olcVf@;o00000oooool001_ooooo
00Go0000olcVfOo<i]Woc>KIon<G3007olcVf@05odJ2]?o<i]Woc>KIolcVfOoS5``01oo<i]T00ooS
5`coc>KIolcVf@0HolcVf@05oi4QW_o<i]Woc>KIolcVfOoS5``03Oo<i]T00ooS5`coc>KIolcVf@0F
olcVf@03on<G3?o<i]Woc>KI01_oc>KI00GohaL<olcVfOo<i]Woc>KIo`00000IolcVf@03on<G3?o<
i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03oi4QW_oS
5`coc>KI00Koc>KI00?ohaL<olcVfOo<i]T06oo<i]T00om6P[Coc>KIolcVf@09olcVf@;o00000ooo
ool001Cooooo0_l00005ooooo`04o`000?o<i]Woc>KIon<G30Soc>KI00CoAX:dolcVfOo<i]WohaL<
2?o<i]T00ooS5`coc>KIolcVf@0>olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GoTB6NolcVfOo<i]Wo
c>KIon<G3006olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00CohaL<o`:XW_o<i]Wo00002Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@05
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?oTB6Non<G3?o<i]T01Oo<i]T00ooS5`coc>KIolcVf@04
olcVf@03o`:XW_o<i]Woc>KI01Goc>KI00?oAX:dolcVfOo<i]T02Oo<i]T2o`0000?ooooo000Coooo
o`04o`000?ooooooooooo`0000Cooooo00?o0000olcVfOoS5``02Oo<i]T01?m6P[Coc>KIolcVfOoS
5``7olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00onA8Ikoc>KIolcV
f@02olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcV
f@02olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcV
fOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co0ZRNo`00000:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:X
W_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00onA8IkohaL<olcVf@05olcVf@03on<G
3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T05Oo<i]T00om6P[Coc>KIolcVf@09olcVf@;o0000
0oooool001?ooooo00Co0000oooooooooooo00001?ooool00ol0003ohaL<olcVf@09olcVf@03odJ2
]?o<i]WohaL<00Ooc>KI00?ohaL<olcVfOo<i]T00_o<i]T3o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00onA8Ikoc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
1_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co
0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`co
c>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00onA8Iko
haL<olcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T3o`:XWP;o
c>KI3OoS5``3olcVf@?o0ZRN0_l00003ooooo`004oooool01?l0003oooooooooool00004oooooooo
00000ol00003ooooo`004oooool01?l0003oooooooooool00004ooooo`03o`000?o<i]Woc>KI00Wo
c>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`co0ZRNo`:XWP0>olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?oTB6NolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Go
c>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Go
c>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0000on<G3?l2Z9h02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00;o
c>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;o
c>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00;o
c>KI00?oTB6Non<G3?o<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ko
c>KI00?o0ZRNon<G3?oS5``00_oS5``<olcVf@03odJ2]?o<i]Woc>KI00Woc>KI0_l00003ooooo`00
4oooool01?l0003oooooooooool00004ooooo`03o`000?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?oTB6NolcVfOo<
i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<
i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<
i]T00_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Co0000olcVfOoS
5`co0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01?o<i]T0
0ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?oTB6Non<G3?o<i]T00oo<i]T0
0ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_oS5``@olcVf@03odJ2]?o<i]Wo
c>KI00Woc>KI0_l00003ooooo`005?ooool2o`0000Gooooo00?o0000olcVfOo<i]T02?o<i]T00ooS
5`coAX:dolcVf@06olcVf@03on<G3?o<i]Woc>KI00goc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00onA
8Ikoc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS
5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS
5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI01Coc>KI00Co0000olcVfOo<i]WohaL<6?o<i]T0
1Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcV
fOo<i]WohaL<00Ooc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@02olcVf@03oi4Q
W_oS5`coc>KI00?oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@05olcVf@;ohaL<
4_o<i]T00om6P[Coc>KIolcVf@09olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T01oo<
i]T00ooS5`coc>KIodJ2]006olcVf@03on<G3?o<i]Woc>KI01goc>KI00?oTB6NolcVfOo<i]T00oo<
i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI01Soc>KI00?ohaL<olcVfOo<i]T06?o<
i]T01Ol0003oc>KIolcVfOo<i]WohaL<01coc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`coc>KI
olcVf@0;olcVf@06on<G3?o<i]Woc>KIolcVfOnA8IkohaL<0oo<i]T00ooS5`coc>KIolcVf@09olcV
f@;ohaL<5?o<i]T00om6P[Coc>KIolcVf@09olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<
i]T01_o<i]T01?oS5`coc>KIolcVfOm6P[@5olcVf@03on<G3?o<i]Woc>KI01koc>KI00?oTB6NolcV
fOo<i]T00oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcV
fOo<i]T05oo<i]T00ol0003oc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcV
fOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0:olcVf@06on<G3?o<i]Woc>KIolcVfOnA8IkohaL<0oo<
i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI01Coc>KI00?oAX:dolcVfOo<i]T02Oo<
i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T0
0om6P[Coc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI01koc>KI00?oTB6NolcVfOo<i]T00oo<i]T0
0ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T05_o<i]T0
0ol0003oc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T05_o<i]T0
0ooS5`coc>KIolcVf@0:olcVf@06on<G3?o<i]Woc>KIolcVfOnA8IkohaL<0oo<i]T00ooS5`coc>KI
olcVf@07olcVf@03on<G3?o<i]Woc>KI01Coc>KI00?oAX:dolcVfOo<i]T02_o<i]T2o`0000?ooooo
000Kooooo`03o`000?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T01Om6P[Coc>KIolcV
fOo<i]WohaL<027oc>KI00?oTB6NolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G
3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ol0003oc>KIolcVf@04olcVf@03on<G
3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@09olcVf@06on<G
3?o<i]Woc>KIolcVfOnA8IkohaL<0oo<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI
01Goc>KI00?oAX:dolcVfOo<i]T02_o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Co
c>KI00?ohaL<olcVfOo<i]T00oo<i]T01?m6P[Coc>KIolcVfOoS5``RolcVf@03oi4QW_o<i]Woc>KI
00Coc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI
01Coc>KI00?o0000olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI
01Goc>KI00?ohaL<olcVfOo<i]T02_o<i]T01OoS5`coc>KIolcVfOnA8IkohaL<00?oc>KI00?ohaL<
olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03odJ2]?o<i]Woc>KI00[oc>KI0_l00003
ooooo`006oooool00ol0003oc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00CoAX:dolcV
fOo<i]WohaL<8_o<i]T00onA8Ikoc>KIolcVf@04olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03_o<
i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?o0000olcVfOo<i]T01_o<
i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<o`:XW_o<i]T02Oo<
i]T01OoS5`coc>KIolcVfOnA8IkohaL<00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KI
olcVf@0GolcVf@03odJ2]?o<i]Woc>KI00[oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcV
f@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?oAX:dolcVfOoS5``06Oo<i]T00ol2Z9koc>KIolcV
f@07olcVf@03oi4QW_o<i]Woc>KI00Goc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T01?l2Z9koc>KI
olcVfOoS5``8olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`co
c>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOl000002Oo<i]T00ooS5`co
0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00Woc>KI00GohaL<olcVfOo<i]WoTB6Non<G3002
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00CohaL<olcVfOo<i]Woc>KI0_l2Z9hEolcVf@03odJ2]?o<
i]Woc>KI00[oc>KI0_l00003ooooo`006oooool01Ol0003oc>KIolcVfOo<i]WohaL<00Soc>KI00?o
AX:don<G3?o<i]T06?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03oi4QW_o<i]Woc>KI00Goc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9ko0000olcVf@09olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``8olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<o`:X
W_o<i]T02?o<i]T01OoS5`coc>KIolcVfOnA8IkohaL<00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T0
1OoS5`coc>KIolcVfOo<i]Wo0ZRN01Ooc>KI00?oAX:dolcVfOo<i]T02_o<i]T2o`0000?ooooo000K
ooooo`05o`000?o<i]Woc>KIolcVfOoS5``02?o<i]T00om6P[CohaL<olcVf@0;olcVf@?o0ZRN2Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03oi4QW_o<i]Woc>KI00Goc>KI00GohaL<olcVfOo<i]Woc>KI
o`:XWP0<olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003o
c>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9ko
c>KIolcVfOoS5``8olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02?o<i]T01OoS
5`coc>KIolcVfOnA8IkohaL<00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T01?oS5`coc>KIolcVfOl2
Z9h=olcVf@?o0ZRN2?o<i]T00om6P[Coc>KIolcVf@07olcVf@?o0ZRN0_l00003ooooo`006oooool3
o`:XWP03on<G3?o<i]Woc>KI00?oc>KI1?l2Z9h01?oS5`coAX:do`:XW_l2Z9h7olcVf@?o0ZRN2oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03oi4QW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KI
o`:XWP0<olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o
0ZRNolcVf@0:olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9ko
c>KIolcVfOoS5``8olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T01oo<i]T01OoS
5`coc>KIolcVfOnA8IkohaL<00;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T01?oS5`coc>KIolcVfOl2
Z9h;olcVf@?o0ZRN2?o<i]T2o`:XWP03odJ2]?l2Z9ko0ZRN00?o0ZRN2?o<i]T00ol2Z9ko0000oooo
o`02ooooo`006oooool00ol0003oc>KIon<G3009olcVf@03on<G3?o<i]WoAX:d00Ooc>KI0_l2Z9h=
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?oTB6NolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<
i]Wo0ZRN00coc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`00
0?o<i]Wo0ZRN00_oc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:X
W_o<i]Woc>KIon<G30Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co0ZRNolcVf@07olcVf@05
on<G3?o<i]Woc>KIoi4QW_oS5``00_o<i]T00ooS5`coc>KIolcVf@02olcVf@03on<G3?o<i]Wo0ZRN
00[oc>KI0_l2Z9h=olcVf@03odJ2]?o<i]Woc>KI00_oc>KI0_l00003ooooo`006oooool00ol0003o
haL<olcVf@09olcVf@03on<G3?o<i]WoAX:d01Goc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00onA8Iko
c>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T01?l2Z9koc>KIolcVfOoS5``:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04
olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Co0000olcVfOo<i]Wo0ZRN2oo<i]T00ooS5`co0ZRNolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2?o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03on<G3?o<i]Woc>KI00Koc>KI00OohaL<olcVfOo<i]WoTB6Non<G3?o<i]WohaL<
00Coc>KI00?ohaL<olcVfOl2Z9h03oo<i]TDon<G30Goc>KI0_l00003ooooo`006oooool00ooS5`co
c>KIolcVf@08olcVf@05on<G3?o<i]Woc>KIolcVfOm6P[@08oo<i]T00onA8Ikoc>KIolcVf@07olcV
f@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T01?l2Z9koc>KIolcVfOoS5``MolcVf@03on<G3?o<
i]Woc>KI00goc>KI00?o0000olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<
i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`co0ZRNolcVf@07olcVf@06on<G3?o<
i]WoTB6Non<G3?o<i]WohaL<1?o<i]T00ooS5`coc>KIolcVf@0<olcVf@?ohaL<2_o<i]T00om6P[Co
c>KIolcVf@07olcVf@KohaL<00?o0000ooooooooool00Oooool001_ooooo00?o0000olcVfOo<i]T0
1oo<i]T00ooS5`coc>KIolcVf@02olcVf@03odJ2]?o<i]Woc>KI02;oc>KI00?oTB6NolcVfOo<i]T0
1_o<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T0
3?o<i]T00ol0003oc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T0
4_o<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G3?nA8IkohaL<00;oc>KI00GohaL<olcVfOo<i]Wo
c>KIon<G300<olcVf@?ohaL<3Oo<i]T00om6P[Coc>KIolcVf@0<olcVf@;o00000oooool001_ooooo
00?o0000olcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@03olcVf@03odJ2]?o<i]Woc>KI027oc>KI
00?oTB6NolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01coc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI01Woc>KI
00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G3?nA8IkohaL<00;oc>KI
00GohaL<olcVfOo<i]Woc>KIon<G300:olcVf@;ohaL<3oo<i]T00om6P[Coc>KIolcVf@0=olcVf@;o
00000oooool001_ooooo00?o0000olcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@04olcVf@03odJ2
]?o<i]Woc>KI027oc>KI00?oTB6NolcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G
3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0@olcVf@03on<G
3?o<i]Woc>KI01Soc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G
3?nA8IkohaL<00;oc>KI00CohaL<olcVfOo<i]WohaL<2Oo<i]T2on<G317oc>KI00?oAX:dolcVfOo<
i]T03Oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T0
1Oo<i]T00om6P[Coc>KIolcVf@0QolcVf@03oi4QW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T0
5?o<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI00Woc>KI00?o0000olcVfOo<i]T0
4Oo<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T0
1Oo<i]T00ooS5`coTB6Non<G3002olcVf@04on<G3?o<i]Woc>KIon<G30Ooc>KI0_oS5``ColcVf@03
odJ2]?o<i]Woc>KI00goc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@05olcVf@03on<G
3?o<i]Woc>KI00Koc>KI00?oAX:dolcVfOo<i]T08?o<i]T00onA8Ikoc>KIolcVf@07olcVf@03on<G
3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@08olcVf@03o`00
0?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G
3?o<i]Woc>KI00Coc>KI00GohaL<oi4QW_oS5`coc>KIon<G3002olcVf@03on<G3?o<i]Woc>KI00Go
c>KI00?ohaL<olcVfOo<i]T04_o<i]T00om6P[Coc>KIolcVf@0>olcVf@;o00000oooool001_ooooo
00?o0000olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@07olcVf@03odJ2]?o<i]Woc>KI01ooc>KI
00?o0ZRNoi4QW_o<i]T02?o<i]T00ol2Z9kohaL<olcVf@0FolcVf@03on<G3?o<i]Woc>KI01coc>KI
00?ohaL<olcVfOo<i]T01oo<i]T00ol0003oc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Soc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI
00GohaL<oi4QW_oS5`co0ZRNon<G3002olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<
i]T04oo<i]T00om6P[Coc>KIolcVf@0>olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T0
0oo<i]T00ooS5`coc>KIolcVf@09olcVf@03odJ2]?o<i]Woc>KI01?oc>KI0_l2Z9h9olcVf@03o`:X
W_nA8Ikoc>KI00Soc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G
3?o<i]Woc>KI00?oc>KI0_l2Z9h00oo<i]Wo0000olcVf@08olcVf@;o0ZRN2oo<i]T00ooS5`coc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI00GohaL<oi4QW_oS5`co0ZRNon<G3002olcVf@03
on<G3?o<i]Woc>KI00?oc>KI00CohaL<olcVfOo<i]Woc>KI0_l2Z9h@olcVf@03odJ2]?o<i]Woc>KI
00ooc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Wo
c>KI00?oAX:dolcVfOo<i]T04_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_nA8Ikoc>KI00Wo
c>KI00?o0ZRNon<G3?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Co
c>KI00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00;o
c>KI00?ohaL<olcVfOo<i]T00oo<i]T01ooS5`coTB6Non<G3?l2Z9kohaL<olcVfOoS5``01_o<i]T0
1?oS5`coc>KIolcVfOl2Z9hBolcVf@03odJ2]?o<i]Woc>KI00ooc>KI0_l00003ooooo`006oooool0
0ol0003oc>KIolcVf@02olcVf@04on<G3?o<i]Woc>KIolcVf@Go0ZRN1Oo<i]T00om6P[Coc>KIolcV
f@04olcVf@Co0ZRN2?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]WoTB6N00Woc>KI00?o
0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@;ohaL<1Oo<i]T00ol0003oc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcV
f@03olcVf@07on<G3?o<i]WohaL<o`:XW_oS5`coc>KIon<G3005olcVf@04on<G3?o<i]Woc>KIo`:X
WPcoc>KI1?l2Z9h2olcVf@03odJ2]?o<i]Woc>KI00Go0ZRN2?o<i]T3o`:XWP;o00000oooool001_o
oooo1?l2Z9h00ooS5`coc>KIolcVf@07olcVf@?o0ZRN0_o<i]T00om6P[Coc>KIolcVf@04o`:XWP_o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIoi4QWP0:olcVf@03o`:XW_oS5`coc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`000?l2Z9koc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?ohaL<o`:XW_o<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Goc>KI00KohaL<olcV
fOoS5`cohaL<olcVfOoS5``5olcVf@04on<G3?o<i]Woc>KIo`:XWPWoc>KI1?l2Z9h6olcVf@03odJ2
]?o<i]Woc>KI00Goc>KI0ol2Z9h8olcVf@03o`:XW_l0003ooooo00;ooooo000Kooooo`05o`000?o<
i]Woc>KIolcVfOoS5``03oo<i]T00om6P[Coc>KIolcVf@0=olcVf@03o`:XW_o<i]Woc>KI00coc>KI
00?o0ZRNolcVfOnA8Ih02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI
00OohaL<olcVfOo<i]Woc>KIo`000?o<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ol2
Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00;oc>KI00KohaL<olcVfOoS5`cohaL<olcVfOoS
5``4olcVf@04on<G3?o<i]Woc>KIo`:XWQ?oc>KI00?oAX:dolcVfOo<i]T04Oo<i]T2o`0000?ooooo
000Kooooo`04o`000?o<i]Woc>KIon<G313oc>KI00?oAX:dolcVfOo<i]T03?o<i]T00ol2Z9koc>KI
olcVf@0=olcVf@03o`:XW_o<i]WoTB6N00[oc>KI00?o0ZRNon<G3?o<i]T03?o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@04olcVf@04on<G3?o<i]Woc>KIo`0000;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co
0ZRNolcVf@09olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T2on<G3004
o`:XW_oS5`coc>KIon<G30Coc>KI00?ohaL<olcVfOl2Z9h05?o<i]T00om6P[Coc>KIolcVf@0AolcV
f@;o00000oooool000Sooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03
o`000?o<i]WohaL<01;oc>KI00?oAX:dolcVfOo<i]T06oo<i]T00ol2Z9koc>KIoi4QWP0;olcVf@03
o`:XW_oS5`coc>KI01Woc>KI00?ohaL<olcVfOo<i]T07_o<i]T2on<G3003o`000?o<i]Woc>KI01[o
c>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcV
fOoS5``01?o<i]T2on<G3003o`:XW_oS5`cohaL<00Coc>KI00?ohaL<olcVfOo<i]T03_o<i]T@on<G
30_oc>KI0_l00003ooooo`001oooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooo
ooooool000001?ooool00ol0003oc>KIon<G300BolcVf@03odJ2]?o<i]Woc>KI01goc>KI00?oTB6N
olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?o0000
olcVfOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<
olcVfOo<i]T00_o<i]T3on<G3003olcVfOoS5`coc>KI00;oc>KI00?ohaL<olcVfOo<i]T03?o<i]T3
on<G30Koc>KI00?oAX:dolcVfOo<i]T01oo<i]T5on<G30Koc>KI0_l00003ooooo`001oooool01?l0
003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo00?o0000on<G3?o<i]T04oo<i]T0
0om6P[Coc>KIolcVf@0MolcVf@03oi4QW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T0
0ooS5`coc>KIolcVf@0NolcVf@03o`000?oS5`coc>KI01coc>KI00?ohaL<olcVfOo<i]T05Oo<i]T0
0ooS5`coc>KIolcVf@0<olcVf@05on<G3?o<i]Woc>KIolcVfOnA8Ih00ooS5``01Oo<i]WohaL<olcV
fOo<i]WohaL<00[oc>KI1OoS5``8olcVf@03odJ2]?o<i]Woc>KI00goc>KI1OoS5``00oo<i]Wo0000
o`000003ooooo`001oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo
00?ohaL<olcVfOo<i]T05?o<i]T00om6P[Coc>KIolcVf@0LolcVf@03oi4QW_o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T06Oo<i]T2on<G31koc>KI00?o0000olcVfOoS5``07Oo<i]T00ooS5`coc>KI
olcVf@0DolcVf@03on<G3?o<i]Woc>KI00goc>KI00CohaL<olcVfOo<i]WoTB6N1?oS5``3olcVf@03
on<G3?o<i]Woc>KI00Coc>KI1?oS5``<olcVf@03odJ2]?o<i]Woc>KI01?oc>KI0_oS5``00ol0003o
ooooooooo`01ooooo`001oooool01?l0003oooooooooool00007ooooo`Co00001Oooool00ol0003o
c>KIolcVf@0DolcVf@03odJ2]?o<i]Woc>KI01coc>KI00?oTB6NolcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI01_oc>KI00Co0000olcVfOo<i]WohaL<7Oo<i]T00ooS
5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI00coc>KI00CohaL<olcVfOo<i]WoTB6N1?oS5``2
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T03_o<i]T00om6P[Coc>KIolcVf@0D
olcVf@;o00000oooool000Oooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`06
ooooo`03o`000?o<i]Woc>KI01Goc>KI00?oAX:dolcVfOo<i]T06oo<i]T00onA8Ikoc>KIolcVf@0<
olcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06_o<i]T01?l0003oc>KIolcVfOo<
i]T2on<G31coc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0;olcVf@04on<G3?o<
i]Woc>KIoi4QWP;ohaL<00Coc>KIon<G3?o<i]WohaL<1_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03
odJ2]?o<i]Woc>KI01Goc>KI0_l00003ooooo`002?ooool2o`0000Sooooo1Ol00004ooooo`03o`00
0?o<i]Woc>KI01Koc>KI00?oAX:dolcVfOo<i]T06?o<i]T00ol2Z9koc>KIoi4QWP07olcVf@03o`:X
W_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0IolcVf@03o`00
0?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0DolcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T01?oS5`coc>KIolcVfOnA8Ih2on<G3004
olcVfOoS5`coc>KIon<G30Goc>KI00?ohaL<olcVfOo<i]T03_o<i]T00om6P[Coc>KIolcVf@0FolcV
f@;o00000oooool001_ooooo00?o0000olcVfOo<i]T05oo<i]T00om6P[Coc>KIolcVf@0GolcVf@04
o`:XW_o<i]Woc>KIoi4QWPKoc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T01OoS5`coc>KIolcVfOo<i]Wo
0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI0_l2Z9h00oo<i]Wo0000olcVf@05olcVf@03on<G3?o<i]Woc>KI00;o0ZRN2oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T0
0ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00GohaL<olcVfOnA8IkohaL<olcV
f@02on<G3003o`:XW_oS5`coc>KI00Coc>KI00?ohaL<olcVfOo<i]T03_o<i]T00om6P[Coc>KIolcV
f@0GolcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T06?o<i]T00om6P[Coc>KIolcVf@0:
olcVf@?o0ZRN2Oo<i]T01?l2Z9koc>KIolcVfOnA8Ih7olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003oc>KI00Koc>KI00GohaL<olcVfOo<i]Wo
c>KIo`:XWP0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`co
c>KIoi4QWP04on<G3003o`:XW_oS5`coc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T2o`:XWPOo
c>KI00?oAX:dolcVfOo<i]T05Oo<i]T3o`:XWP;o00000oooool001_ooooo0ol2Z9h6olcVf@Go0ZRN
2?o<i]T5o`:XWP03olcVfOm6P[Coc>KI00Ooc>KI0ol2Z9h;olcVf@05o`:XW_o<i]Woc>KIolcVfOnA
8Ih01oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol0003oc>KIolcVf@06olcVf@;ohaL<0_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@05
on<G3?o<i]Woc>KIolcVfOl2Z9h01_o<i]T00ooS5`coc>KIoi4QWP02on<G3004olcVfOoS5`coc>KI
on<G30?oc>KI00?ohaL<olcVfOo<i]T00oo<i]T3o`:XWPOoc>KI00?o0ZRNodJ2]?l2Z9h00_l2Z9h8
olcVf@Go0ZRN2oo<i]T00ol2Z9ko0000ooooo`02ooooo`006oooool01?l0003oc>KIolcVfOl2Z9h:
olcVf@?o0ZRN2_o<i]T00ol2Z9koAX:do`:XWP05olcVf@;o0ZRN3_o<i]T01Ol2Z9koc>KIolcVfOo<
i]WoTB6N00Soc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0000o`:XW_o<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIoi4QWP03on<G3003o`:X
W_oS5`coc>KI00;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T2o`:XWP_oc>KI00CoAX:dolcVfOo<i]Wo
c>KI0ol2Z9h:olcVf@?o0ZRN2?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI01[oc>KI
00?oAX:dolcVfOo<i]T04oo<i]T01Ol2Z9koc>KIolcVfOo<i]WoTB6N00Soc>KI00?o0ZRNolcVfOo<
i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000olcVfOl2
Z9h02Oo<i]T01?oS5`coc>KIolcVfOl2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h01Oo<i]T0
0ooS5`coc>KIoi4QWP03on<G3005o`:XW_oS5`coc>KIolcVfOoS5``04Oo<i]T00om6P[Coc>KIolcV
f@0JolcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T06oo<i]T00om6P[Coc>KIolcVf@0A
olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?oTB6NolcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@06
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?l0003oc>KIolcVfOl2
Z9h9olcVf@04on<G3?o<i]Woc>KIo`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00CohaL<olcVfOo<i]Wo0ZRN1Oo<i]T00ooS5`co
TB6NolcVf@04on<G30;oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00om6P[Coc>KIolcVf@0KolcVf@;o
00000oooool001_ooooo00?o0000olcVfOo<i]T07?o<i]T00om6P[Coc>KIolcVf@0@olcVf@03o`:X
W_o<i]Woc>KI00?oc>KI00?oTB6NolcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G
3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ol0003oc>KIolcVf@0;olcVf@;ohaL<
6_o<i]T00ooS5`coc>KIolcVf@0AolcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h01Oo<i]T02?oS5`co
c>KIon<G3?oS5`co0ZRNon<G3?o<i]WohaL<2oo<i]T=on<G31Soc>KI0_l00003ooooo`006oooool0
0ol0003oc>KIolcVf@0MolcVf@;oAX:d5_o<i]T00onA8Ikoc>KIolcVf@0@olcVf@03on<G3?o<i]Wo
c>KI01koc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ol0003oc>KIolcVf@0=olcVf@03on<G3?o<i]Wo
c>KI01Soc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@06olcVf@CohaL<00Coc>KI
on<G3?o<i]WohaL<1_o<i]T5on<G30Coc>KI0_m6P[@7olcVf@KohaL<4_o<i]T2o`0000?ooooo000K
ooooo`03o`000?o<i]Woc>KI01ooc>KI00?oAX:dolcVfOo<i]T04oo<i]T00onA8Ikoc>KIolcVf@0A
olcVf@03on<G3?o<i]Woc>KI01koc>KI0_oS5``AolcVf@03o`000?o<i]Woc>KI00koc>KI00?ohaL<
olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI00Koc>KI1OoS5``0
0oo<i]WohaL<olcVf@03olcVf@?ohaL<2?o<i]T00om6P[Coc>KIolcVf@0=olcVf@GohaL<3Oo<i]T2
o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI023oc>KI00?oAX:dolcVfOo<i]T04oo<i]T00onA
8Ikoc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ol0
003oc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI01Soc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS
5`coc>KIolcVf@06olcVf@?ohaL<00?oc>KIon<G3?oS5``01?o<i]T00ooS5`coc>KIolcVf@08olcV
f@03odJ2]?o<i]Woc>KI01?oc>KI1?oS5``9olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<
i]T08Oo<i]T00om6P[Coc>KIolcVf@0BolcVf@03oi4QW_o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<
i]T07oo<i]T2on<G30koc>KI00?o0000olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0HolcVf@03
on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T01?o<i]T00onA8IkohaL<on<G3003on<G30?o
c>KI0_oS5``:olcVf@03odJ2]?o<i]Woc>KI01Soc>KI1OoS5``4olcVf@;o00000oooool001_ooooo
00?o0000olcVfOo<i]T08_o<i]T2odJ2]1;oc>KI00?oTB6NolcVfOo<i]T04oo<i]T00ooS5`coc>KI
olcVf@0PolcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T04Oo<i]T2on<G31Woc>KI
00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@04olcVf@03oi4QW_oS5`cohaL<00?ohaL<
0_o<i]T00ooS5`coc>KIolcVf@09olcVf@03odJ2]?o<i]Woc>KI01koc>KI1?oS5``2o`0000?ooooo
000Kooooo`?ohaL<9?o<i]T00om6P[Coc>KIolcVf@0@olcVf@05oi4QW_o<i]Woc>KIolcVfOl2Z9h0
4Oo<i]T00ooS5`coc>KIolcVf@0PolcVf@;ohaL<2oo<i]T00ol0003oc>KIolcVf@0ColcVf@03on<G
3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ol2Z9koc>KIon<G3005olcVf@03oi4Q
W_oS5`cohaL<00;ohaL<0_o<i]T00ooS5`coc>KIolcVf@09olcVf@03odJ2]?o<i]Woc>KI02?oc>KI
00?ohaL<o`000?ooool00_ooool001_ooooo00?o0000olcVfOo<i]T00ooS5``RolcVf@03odJ2]?o<
i]Woc>KI00[oc>KI0_l2Z9h3olcVf@05oi4QW_o<i]Woc>KIolcVfOl2Z9h02oo<i]T00ol2Z9koc>KI
olcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP?oc>KI
00?ohaL<olcVfOo<i]T01Oo<i]T2o`:XWP03olcVfOl0003oc>KI00Soc>KI0_l2Z9h;olcVf@03on<G
3?l2Z9koc>KI00[oc>KI0_l2Z9h;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]Wo
haL<0oo<i]T00onA8Ikoc>KIon<G3003on<G3003olcVfOoS5`coc>KI00;o0ZRN2?o<i]T00om6P[Co
c>KIolcVf@0TolcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T00oo<i]T3on<G30?o0ZRN
2_o<i]T3o`:XWQ3oc>KI00?oAX:dolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@04olcVf@05oi4Q
W_o<i]Woc>KIolcVfOl2Z9h02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Co
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@05o`:XW_o<i]Woc>KIolcV
fOoS5``02?o<i]T00ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:X
W_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOoS5``00oo<i]T00onA8IkohaL<on<G3002on<G3004olcVfOoS5`coc>KIo`:XWPWoc>KI00?oAX:d
olcVfOo<i]T02?o<i]T3o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN0_l00003ooooo`006oooool3o`:X
WPKoc>KI0ooS5``3o`:XWP[oc>KI0ol2Z9h7olcVf@Go0ZRN0_o<i]T00om6P[Coc>KIolcVf@05olcV
f@;o0ZRN1oo<i]T01OnA8Ikoc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T2
on<G30Goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN0_o<i]T2
on<G30Ooc>KI00?o0000o`:XW_o<i]T02_o<i]T2o`:XWP[oc>KI0_oS5``00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS
5``2olcVf@03oi4QW_oS5`cohaL<00?ohaL<0_l2Z9h5olcVf@GohaL<0ol2Z9h;olcVf@?o0ZRN2_o<
i]T3o`:XWP[oc>KI00?o0ZRNo`000?ooool00_ooool001_ooooo00Co0000olcVfOo<i]Wo0ZRN2?o<
i]T3on<G30;o0ZRN2oo<i]T2o`:XWP[oc>KI0ol2Z9h2odJ2]0Coc>KI00?o0ZRNolcVfOo<i]T01oo<
i]T00onA8Ikoc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<
i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Koc>KI00?o0000olcVfOl2Z9h03?o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KI
olcVf@0:olcVf@06o`:XW_o<i]WohaL<olcVfOnA8Ikoc>KI1?oS5``00ol2Z9koc>KIolcVf@02olcV
f@?ohaL<0_o<i]T2odJ2]003olcVfOoS5`cohaL<00OohaL<2?o<i]T2o`:XWP_oc>KI0_l2Z9h8olcV
f@;o00000oooool001_ooooo00?o0000olcVfOo<i]T03?o<i]T3on<G31_oc>KI0_m6P[@00oo<i]Wo
0ZRNolcVf@0:olcVf@05oi4QW_o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@05olcV
f@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@04o`:XW_o<i]Woc>KIolcVf@;ohaL<1?o<i]T01?l0003oc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI0_oS5``;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02Oo<
i]T01_l2Z9koc>KIon<G3?o<i]WoTB6NolcVf@CohaL<00?oc>KIon<G3?oS5``00_oS5``3olcVf@;o
AX:d3?o<i]T5on<G31[oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0?olcVf@?ohaL<
6_o<i]T00om6P[Coc>KIolcVf@0:olcVf@05oi4QW_o<i]Woc>KIolcVfOl2Z9h03_o<i]T00ol2Z9ko
c>KIolcVf@05olcVf@;ohaL<8oo<i]T01OoS5`coc>KIolcVfOo<i]Wo000001goc>KI00?ohaL<olcV
fOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@08olcVf@05o`:XW_o<i]WohaL<olcVfOnA8Ih01_oS5``6
olcVf@03odJ2]?o<i]Woc>KI017oc>KI0ooS5``GolcVf@;o00000oooool001_ooooo00?o0000olcV
fOo<i]T04_o<i]T4on<G31Ooc>KI00?oAX:dolcVfOo<i]T02_o<i]T01OnA8Ikoc>KIolcVfOo<i]Wo
0ZRN01Ooc>KI00?ohaL<olcVfOo<i]T08Oo<i]T2on<G3003olcVfOl0003oc>KI01goc>KI0_oS5``F
olcVf@03on<G3?o<i]Woc>KI00Soc>KI00Co0ZRNon<G3?nA8Ikoc>KI1?oS5``6olcVf@;oAX:d5oo<
i]T3on<G31Coc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0FolcVf@?ohaL<5Oo<i]T2
odJ2]0[oc>KI00?oTB6NolcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0RolcVf@03on<G3?l0003o
c>KI01ooc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?nA8Iko
c>KI00?ohaL<1_o<i]T00om6P[Coc>KIolcVf@0JolcVf@?ohaL<4Oo<i]T2o`0000?ooooo000Koooo
o`03o`000?o<i]Woc>KI01Woc>KI1?oS5``ColcVf@03odJ2]?o<i]Woc>KI00Ooc>KI00?oTB6NolcV
fOo<i]T06oo<i]T2on<G32?oc>KI00?o0000on<G3?o<i]T07oo<i]T2on<G31Goc>KI00?ohaL<olcV
fOo<i]T01oo<i]T00ooS5`coc>KIon<G3002on<G30Goc>KI0_m6P[@PolcVf@;ohaL<3oo<i]T2o`00
00?ooooo000Kooooo`03o`000?o<i]Woc>KI01goc>KI0ooS5``AolcVf@03odJ2]?o<i]Woc>KI00Oo
c>KI00?oTB6NolcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0PolcVf@04o`000?o<i]WohaL<on<G
323oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@06olcVf@05on<G3?o<i]WohaL<
on<G3?o<i]T03?oS5``MolcVf@?ohaL<3?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI
023oc>KI0_oS5``@olcVf@;oAX:d1oo<i]T00onA8Ikoc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI
01ooc>KI00Co0000olcVfOo<i]Woc>KI0_oS5``OolcVf@;ohaL<5?o<i]T00ooS5`coc>KIolcVf@04
olcVf@03oi4QW_oS5`cohaL<00?ohaL<0_o<i]T2odJ2]0Soc>KI1?oS5``LolcVf@;ohaL<2_o<i]T2
o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI02;oc>KI0ooS5``?olcVf@;oAX:d1Oo<i]T00onA
8Ikoc>KIolcVf@0NolcVf@;ohaL<7oo<i]T00ol0003oc>KIolcVf@03olcVf@;ohaL<7oo<i]T2on<G
31?oc>KI00?ohaL<olcVfOo<i]T00oo<i]T01?nA8IkohaL<on<G3?oS5``2olcVf@;oAX:d3_o<i]T3
on<G31_oc>KI0ooS5``7olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<i]T09Oo<i]T3on<G
30koc>KI0om6P[@3olcVf@03oi4QW_o<i]Woc>KI01ooc>KI0ooS5``LolcVf@03o`000?o<i]Woc>KI
00Goc>KI00?ohaL<olcVfOo<i]T07_o<i]T2on<G31;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T3on<G
30?oAX:d4oo<i]T2on<G31coc>KI0ooS5``4olcVf@;o00000oooool001?ooooo0ol00005ooooo`03
o`000?o<i]Woc>KI02Soc>KI0ooS5``>olcVf@;oAX:d00?oc>KIoi4QW_l2Z9h08oo<i]T2on<G31[o
c>KI00?o0000olcVfOo<i]T01_o<i]T2on<G323oc>KI00?ohaL<olcVfOo<i]T04?o<i]T01?oS5`co
c>KIo`:XW_nA8Ih9on<G31;oc>KI0_oS5``MolcVf@;ohaL<0_o<i]T2o`0000?ooooo000Dooooo`03
o`000?oooooooooo00Cooooo00?o0000olcVfOo<i]T01_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o
0ZRN2Oo<i]T01?oS5`coc>KIo`:XW_l2Z9h<olcVf@;oAX:d00?oc>KIo`:XW_o<i]T01_o<i]T2o`:X
WP_oc>KI0_l2Z9h;olcVf@;o0ZRN00?oc>KIon<G3?oS5``02?o<i]T2o`:XWP_oc>KI0_l2Z9h00oo<
i]Wo0000olcVf@08olcVf@03o`:XW_oS5`cohaL<00Woc>KI0_l2Z9h;olcVf@;o0ZRN1oo<i]T2on<G
30;oc>KI0_l2Z9h=olcVf@03on<G3?o<i]WohaL<00;ohaL<1_o<i]T01?l2Z9kohaL<on<G3?oS5``9
olcVf@;o0ZRN1_o<i]T3on<G30;oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T01Ol2Z9kohaL<on<G3?oS
5`co000000?ooooo000Dooooo`03o`000?oooooooooo00Cooooo0_oS5``9olcVf@?o0ZRN2_o<i]T3
o`:XWP[oc>KI0ol2Z9h7olcVf@?ohaL<0_l2Z9h:olcVf@05o`:XW_o<i]WohaL<odJ2]?l2Z9h02?o<
i]T3o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN0ooS5``7olcVf@?o0ZRN2_o<i]T00ol2Z9ko0000olcV
f@0:olcVf@04o`:XW_oS5`cohaL<on<G30Soc>KI0ol2Z9h:olcVf@?o0ZRN1_o<i]T3on<G3004olcV
fOl2Z9ko0ZRNo`:XWPWoc>KI00Go0ZRNon<G3?oS5`cohaL<o`:XWP04on<G30Goc>KI0_l2Z9h2on<G
30Woc>KI0_l2Z9h7olcVf@;ohaL<0_o<i]T2o`:XWP[oc>KI0ol2Z9h;olcVf@03o`:XW_l0003ooooo
00;ooooo000Dooooo`03o`000?oooooooooo00Cooooo00?o0000olcVfOoS5``00_oS5``9olcVf@;o
0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h8olcVf@;ohaL<0_l2Z9h9olcVf@03o`:XW_nA8Iko0ZRN00?o
AX:d2Oo<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN00?oc>KIon<G3?oS5``02?o<i]T2o`:XWPWo
c>KI00?o0000o`:XW_l2Z9h02oo<i]T2o`:XWP;ohaL<2Oo<i]T2o`:XWP_oc>KI0_l2Z9h7olcVf@?o
haL<00?oc>KIo`:XW_l2Z9h01Oo<i]T2odJ2]0CohaL<00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`co
c>KIolcVf@04olcVf@;o0ZRN0ooS5``8olcVf@;o0ZRN1oo<i]T2on<G30;oc>KI0_l2Z9h;olcVf@;o
0ZRN2Oo<i]T2o`0000?ooooo000Dooooo`03o`000?oooooooooo00Cooooo00Go0000olcVfOo<i]Wo
0ZRNolcVf@02on<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOl2Z9h02Oo<i]T00ol2Z9koTB6NolcVf@02olcVf@?o
AX:d2?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T00ooS5``7olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00Co0000olcVfOo<i]Wo0ZRN3?o<i]T01?l2
Z9koc>KIon<G3?oS5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T3
on<G3003o`:XW_o<i]Woc>KI00;oAX:d00Ooc>KIon<G3?oS5`coTB6No`:XW_o<i]WohaL<00Goc>KI
0_oS5``6olcVf@03o`:XW_o<i]Woc>KI00;ohaL<2?o<i]T00ol2Z9koc>KIolcVf@06olcVf@;ohaL<
0_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00003ooooo`004ooo
ool2o`0000Kooooo00?o0000olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@0[olcVf@03on<G3?o<
i]Woc>KI00Woc>KI00?oTB6NolcVfOo<i]T01?o<i]T3odJ2]2Goc>KI0ooS5``=olcVf@03o`000?o<
i]Woc>KI017oc>KI0ooS5``PolcVf@OohaL<00?oc>KIoi4QW_o<i]T00_o<i]T00ooS5`coc>KIolcV
f@04olcVf@03on<G3?o<i]Woc>KI00Soc>KI0_oS5``AolcVf@;ohaL<5_o<i]T2o`0000?ooooo000D
ooooo`03o`000?oooooooooo00Cooooo00?o0000olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@0[
olcVf@;ohaL<2_o<i]T00onA8Ikoc>KIolcVf@06olcVf@;oAX:d9_o<i]T4on<G30Woc>KI00?o0000
olcVfOo<i]T05?o<i]T3on<G31_oc>KI0_m6P[@2olcVf@CohaL<00?oc>KIoi4QW_o<i]T01?o<i]T0
0ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T04?o<i]T2
on<G31Coc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@06olcVf@;ohaL<;Oo<i]T2on<G
30Soc>KI00?oTB6NolcVfOo<i]T02?o<i]T3odJ2]2Ooc>KI0ooS5``6olcVf@03o`000?o<i]Woc>KI
01Ooc>KI1?oS5``DolcVf@?oAX:d0_o<i]T4on<G30?oc>KI00?oTB6NolcVfOo<i]T01?o<i]T00ooS
5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Woc>KI0_oS5``BolcVf@;ohaL<4_o<i]T2o`00
00?ooooo000Kooooo`03o`000?o<i]Woc>KI00Soc>KI0ooS5``/olcVf@03on<G3?o<i]Woc>KI00Ko
c>KI00?oTB6NolcVfOo<i]T02_o<i]T2odJ2]2Soc>KI1?oS5``2olcVf@03o`000?o<i]Woc>KI01_o
c>KI0ooS5``>olcVf@?oAX:d00?oc>KIon<G3?oS5``01?oS5``4olcVf@03oi4QW_o<i]Woc>KI00Ko
c>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@0:olcVf@;ohaL<4_o<i]T2on<G313o
c>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0;olcVf@;ohaL<:_o<i]T00ooS5`coc>KI
olcVf@06olcVf@03oi4QW_o<i]Woc>KI00coc>KI0om6P[@YolcVf@;ohaL<00?o0000olcVfOo<i]T0
7_o<i]TBon<G3004olcVfOoS5`cohaL<on<G30Koc>KI00?oTB6NolcVfOo<i]T01oo<i]T00ooS5`co
c>KIolcVf@04olcVf@;ohaL<3?o<i]T00ooS5`coc>KIolcVf@0AolcVf@;ohaL<3_o<i]T2o`0000?o
oooo000Kooooo`03o`000?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T0:?o<i]T00ooS5`coc>KI
olcVf@05olcVf@03oi4QW_o<i]Woc>KI00ooc>KI1?m6P[@WolcVf@03o`000?oS5`cohaL<00CohaL<
8Oo<i]T4odJ2]0Coc>KI1?oS5``9olcVf@03oi4QW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOo<i]T0
1Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@;ohaL<4oo<i]T2on<G30coc>KI0_l00003ooooo`006ooo
ool00ol0003oc>KIolcVf@0>olcVf@;ohaL<:?o<i]T00ooS5`coc>KIolcVf@06olcVf@03oi4QW_o<
i]Woc>KI01;oc>KI1Om6P[@RolcVf@03o`000?o<i]Woc>KI00Coc>KI1_oS5``FolcVf@GoAX:d0_o<
i]T6on<G30coc>KI00?oTB6NolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<
i]Woc>KI00_oc>KI0_oS5``ColcVf@03on<G3?o<i]Woc>KI00Woc>KI0_l00003ooooo`006oooool0
0ol0003oc>KIolcVf@0@olcVf@;ohaL<7?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo
0ZRN00Goc>KI00?oTB6NolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0<olcVf@GoAX:d7Oo<i]T0
0ol0003oc>KIolcVf@0:olcVf@KohaL<2oo<i]T5odJ2]0OohaL<2oo<i]T00ol2Z9koc>KIolcVf@04
olcVf@04oi4QW_o<i]Woc>KIo`:XWP[oc>KI00?ohaL<o`:XW_o<i]T01Oo<i]T00ooS5`coc>KIolcV
f@0<olcVf@03on<G3?o<i]Woc>KI017oc>KI0_oS5``9olcVf@;o00000oooool001_ooooo00?o0000
olcVfOo<i]T01_o<i]T2o`:XWP[oc>KI0_oS5``00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN3Oo<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03on<G3?l2Z9koc>KI00Goc>KI00?oTB6NolcVfOo<i]T01oo<i]T0
0ol2Z9koc>KIolcVf@0AolcVf@KoAX:d5oo<i]T00ol0003oc>KIolcVf@0@olcVfA3ohaL<4_o<i]T0
0ol2Z9koc>KIolcVf@03olcVf@05oi4QW_o<i]Woc>KIolcVfOl2Z9h02oo<i]T00ooS5`co0ZRNolcV
f@05olcVf@;ohaL<0_o<i]T2o`:XWPWoc>KI0_oS5``2o`:XWP_oc>KI0_l2Z9h4olcVf@;ohaL<1?o<
i]T2o`:XWP03olcVfOl0003o000000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Soc>KI0_l2Z9h:
olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08
olcVf@03on<G3?l2Z9koc>KI00Coc>KI00?oTB6NolcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@?o0ZRN2oo<i]T8odJ2]0ooc>KI00?o0000olcVfOo<i]T03_o<i]T8odJ2]0ooc>KI0ol2Z9h9
olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?oTB6NolcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03on<G3?l2Z9koc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0:olcVf@;ohaL<00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@;ohaL<1?o<i]T2o`:XWP03o`000?oo
oooooooo007ooooo000Kooooo`;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;ohaL<00?o0ZRN
olcVfOo<i]T02Oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS5`co0ZRNolcVf@05
olcVf@03oi4QW_o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02?o<i]T3o`:XWPSoc>KI2?l2Z9h5
olcVf@03o`:XW_m6P[CoAX:d00goAX:d00?o0000odJ2]?m6P[@03_m6P[@00ol2Z9koc>KIolcVf@02
olcVf@So0ZRN1oo<i]T3o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00onA8Ikoc>KIolcVf@03
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T01_o<i]T01?oS5`coc>KIolcVfOo<
i]T2o`:XWP[oc>KI00?ohaL<o`:XW_l2Z9h02oo<i]T2o`:XWPGoc>KI0_oS5``3olcVf@;o00000ooo
ool001_ooooo00?o0000olcVfOl2Z9h02oo<i]T2o`:XWP[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<o`:XW_o<i]T01Oo<i]T0
0onA8Ikoc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l2Z9hXolcVf@03o`000?o<i]Wo
c>KI023oc>KI0_l2Z9h>olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?oTB6NolcVfOo<i]T01Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T0
0ol2Z9koc>KIolcVf@08olcVf@;ohaL<00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04
olcVf@;ohaL<00?oc>KIo`000?l000000oooool001_ooooo00Co0000olcVfOo<i]Wo0ZRN3?o<i]T0
0ol2Z9koc>KIolcVf@08olcVf@;ohaL<3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Koc>KI00?ohaL<o`:XW_o<i]T01_o<i]T01OnA8Ikoc>KIolcVfOo<i]Wo0ZRN03?oc>KI00?o
0000olcVfOo<i]T0<?o<i]T00ol2Z9koc>KIolcVf@03olcVf@03oi4QW_o<i]Woc>KI00Goc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ooS5`co0ZRNolcVf@06olcVf@;ohaL<0oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T2on<G3003o`000?oo
oooooooo007ooooo000Kooooo`;ohaL<6oo<i]T00ooS5`coc>KIolcVf@0PolcVf@03on<G3?l2Z9ko
c>KI00Goc>KI00CoTB6NolcVfOo<i]Wo0ZRN=?o<i]T00ol0003oc>KIolcVf@0_olcVf@03o`:XW_o<
i]Woc>KI00?oc>KI00?oTB6NolcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<
i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T03Oo<i]T2on<G31Coc>KI0_l00003ooooo`006oooool0
0ol0003oc>KIon<G300KolcVf@;ohaL<8?o<i]T00ooS5`coc>KIolcVf@06olcVf@03oi4QW_o<i]Wo
c>KI03Coc>KI00?o0000olcVfOo<i]T0=Oo<i]T00onA8Ikoc>KIolcVf@0FolcVf@03on<G3?o<i]Wo
c>KI00Ooc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0AolcVf@;o00000oooool0
01_ooooo00?o0000olcVfOo<i]T00_oS5``KolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcV
fOo<i]T01oo<i]T00onA8Ikoc>KIolcVf@0colcVf@03o`000?o<i]Woc>KI03Coc>KI00?oTB6NolcV
fOo<i]T06?o<i]T00ooS5`coc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcV
fOo<i]T04?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<
i]T06Oo<i]T2on<G31koc>KI00?ohaL<olcVfOo<i]T01oo<i]T00onA8Ikoc>KIolcVf@0bolcVf@03
o`000?o<i]Woc>KI03?oc>KI00?oTB6NolcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@07olcVf@;o
haL<3oo<i]T2on<G313oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@03olcVf@;ohaL<
6oo<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI00Koc>KI00?oTB6NolcVfOo<i]T0
<_o<i]T00ol0003oc>KIolcVf@0bolcVf@03oi4QW_o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T0
2?o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00goc>KI0_l00003ooooo`006ooo
ool00ol0003oc>KIolcVf@05olcVf@;ohaL<6_o<i]T00ooS5`coc>KIolcVf@0KolcVf@03on<G3?o<
i]Woc>KI00Ooc>KI00?oTB6NolcVfOo<i]T0<Oo<i]T00ol0003oc>KIolcVf@0aolcVf@03oi4QW_o<
i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@0>olcVf@;ohaL<3Oo<
i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T06?o<i]T0
0ooS5`coc>KIolcVf@0FolcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00onA8Ikoc>KIolcV
f@0<olcVf@03o`:XW_o<i]Woc>KI02;oc>KI00?o0000olcVfOo<i]T09Oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_nA8Ikoc>KI00Woc>KI00?o0ZRNolcVfOo<i]T05?o<i]T00ooS5`coc>KIolcV
f@08olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T02_o<i]T2o`0000?ooooo000K
ooooo`03o`000?o<i]Woc>KI00Soc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@02
olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0ZRNoi4QW_o<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?l0003oc>KIo`:XW_l2
Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o
TB6NolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
haL<o`:XW_o<i]T02?o<i]T2on<G30;o0ZRN3_o<i]T2on<G30Soc>KI00Co0ZRNolcVfOl0003o0000
0oooool001_ooooo00?o0000olcVfOo<i]T01oo<i]T2o`:XWP03on<G3?o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Go
0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]WoTB6N00_oc>KI00?o0ZRNolcVfOo<i]T0
3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_o<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T00onA8Iko0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`co0ZRNolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00[oc>KI0_l2Z9h3olcVf@03on<G
3?o<i]Woc>KI00Coc>KI0_l2Z9h00oo<i]Wo0000o`000003ooooo`006oooool00ol0003oc>KIolcV
f@09olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@04o`:X
W_o<i]Woc>KIoi4QWP[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00onA8Ikoc>KIo`:XWP0<olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@09olcVf@03
on<G3?o<i]Wo0ZRN00_oc>KI00Co0ZRNolcVfOo<i]Woc>KI0_oS5``6olcVf@;o0ZRN00?o0000oooo
ooooool00Oooool001_ooooo0_l2Z9h;olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9kohaL<olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<
i]Woc>KIon<G3008olcVf@04o`:XW_o<i]Woc>KIoi4QWPSoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNo`000?o<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T0
1OnA8Ikoc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03on<G3?l2Z9koc>KI00Woc>KI00?ohaL<olcVfOl2Z9h02oo<i]T2o`:XWP?oc>KI00?o
haL<olcVfOo<i]T01?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Wo0ZRN00_oc>KI00Co0ZRN
on<G3?oS5`cohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00Soc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00Go0ZRNolcVfOo<i]Wo
c>KIoi4QWP07olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Wo000000[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?oTB6NolcVfOo<i]T00_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`co
0ZRNolcVf@09olcVf@;ohaL<00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<
00Goc>KI0_l00003ooooo`006oooool01?l0003oc>KIolcVfOl2Z9h;olcVf@04o`:XW_o<i]Woc>KI
on<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@08olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@05o`:XW_o<i]Woc>KIolcVfOnA8Ih0
1oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T01?l2Z9koc>KIolcVfOl00009olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03oi4QW_o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<o`:XW_o<
i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@04o`:XW_o<i]Woc>KIolcVf@;ohaL<0oo<i]T2o`00
00?ooooo000Kooooo`03o`000?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`co
c>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3007olcV
f@03o`:XW_o<i]Woc>KI00;oc>KI00?oTB6NolcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI01Woc>KI00?o0000olcVfOo<i]T05Oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Goc>KI00?oTB6NolcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcV
f@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T00_l00003ooooo`001oooool3o`0000Co
oooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000olcVfOo<i]T04Oo<i]T00ooS5`co
c>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T02oo<i]T00onA8Iko
c>KIolcVf@0ZolcVf@03o`000?o<i]Woc>KI02[oc>KI00?oTB6NolcVfOo<i]T0;_o<i]T00ooS5`co
c>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI013oc>KI0_oS5``2o`0000?ooooo0008ooooo`03o`00
0?oooooooooo00Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?o<i]Woc>KI01;o
c>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?oTB6NolcVfOo<i]T0:Oo<i]T00ol0003oc>KIolcVf@0YolcVf@03oi4QW_o<i]Woc>KI033o
c>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?l0003ooooo00;o
oooo0008ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool00ooS5`coc>KI
olcVf@0ColcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KI
olcVf@0<olcVf@;oTB6N:Oo<i]T00ol0003oc>KIolcVf@0WolcVf@;oTB6N=?o<i]T00ooS5`coc>KI
olcVf@0:olcVf@;ohaL<4Oo<i]T2o`0000?ooooo0008ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool00_ooool00ol0003ohaL<olcVf@0DolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?o
haL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0>olcVf@03oi4QW_o<i]Woc>KI02Koc>KI00?o
0000olcVfOo<i]T09_o<i]T00onA8Ikoc>KIolcVf@0eolcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o
haL<olcVfOo<i]T03_o<i]T2o`0000?ooooo0008ooooo`03o`000?oooooooooo00Oooooo1?l00005
ooooo`03o`000?o<i]WohaL<01Goc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0E
olcVf@03on<G3?o<i]Woc>KI00koc>KI00?oTB6NolcVfOo<i]T09Oo<i]T00ol0003oc>KIolcVf@0U
olcVf@03oi4QW_o<i]Woc>KI03Ooc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0=
olcVf@;o00000oooool000Oooooo0_l00009ooooo`03o`000?oooooooooo00Kooooo00?o0000olcV
fOo<i]T00_oS5``DolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00onA
8Ikoc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0
003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koTB6NolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T08Oo<i]T00ooS
5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00coc>KI0_l00003ooooo`002?ooool00ol0003o
ooooooooo`07ooooo`Go00001?ooool00ol0003oc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00;o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI
00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koTB6Noi4QWP0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2oi4QWPcoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`:XW_oS5`cohaL<00[oc>KI00Co0ZRNolcVfOl0003o00000oooool0
01_ooooo00?o0000olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00Co0ZRNolcVfOo<i]WoTB6N2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Ooc>KI00?oTB6NolcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;ohaL<2oo<
i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_l0003o000000?ooooo000Kooooo`03o`000?o<i]Wo
c>KI00Coc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:XW_o<i]Wo
c>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@09olcVf@05o`:XW_o<
i]Woc>KIolcVfOnA8Ih02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI
00CoTB6NolcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[o
c>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9ko0000ooooo`02ooooo`006oooool2o`:XWPKoc>KI
0_oS5``3olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`co
c>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIoi4QWP07olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00onA8Ikoc>KIolcVf@02olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcV
f@03o`:XW_o<i]WohaL<00Woc>KI0_l00003ooooo`006oooool00ol0003oc>KIo`:XWP07olcVf@05
on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Wo
c>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@02olcVf@03oi4QW_o<i]Wo
c>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03oi4QW_o<i]Wo
c>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`co
c>KI00[oc>KI00Co0ZRNolcVfOoS5`cohaL<1oo<i]T2o`0000?ooooo000Kooooo`04o`000?o<i]Wo
c>KIo`:XWPOoc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@04o`:XW_o<i]Woc>KIon<G30Wo
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Ko
c>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00?o
c>KI00?oTB6NolcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Co
c>KI00?oTB6NolcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNon<G3?o<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``6olcVf@;o00000oooool001_o
oooo00?o0000olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI01;o
c>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03oi4QW_o<i]Woc>KI00;o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003oc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03oi4QW_o<i]Woc>KI00Go
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00?o
c>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI017oc>KI
00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI01Koc>KI
0_nA8IhLolcVf@03o`000?o<i]Woc>KI01[oc>KI0_nA8Ii=olcVf@03on<G3?o<i]Woc>KI00coc>KI
00?ohaL<olcVfOo<i]T00_o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00_oc>KI00?o
haL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T06?o<i]T2oi4QWQ[oc>KI00?o0000olcVfOo<i]T06?o<i]T2oi4QWU3oc>KI00?o
haL<olcVfOo<i]T03?o<i]T2on<G30;oc>KI0_l00003ooooo`006oooool00ol0003oc>KIolcVf@0<
olcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0A
olcVf@03on<G3?o<i]Woc>KI01Woc>KI0onA8IhGolcVf@03o`000?o<i]Woc>KI01Koc>KI0_nA8IiC
olcVf@03on<G3?o<i]Woc>KI00goc>KI00CohaL<olcVfOl0003o00000oooool001_ooooo00?o0000
olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<
olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0LolcVf@;oTB6N5Oo<i]T00ol0003oc>KIolcVf@0D
olcVf@;oTB6NE_o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?l0003o000000?ooooo000Koooo
o`03o`000?o<i]Woc>KI00koc>KI0_oS5``AolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcV
fOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0NolcVf@?oTB6N4_o<i]T00ol0003oc>KIolcVf@0AolcV
f@?oTB6NFOo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?l0003ooooo00;ooooo000Kooooo`03
on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@?o
TB6N0_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01?nA8Ih5olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI00coc>KI0_l00003ooooo`006oooool00ooS5`coc>KI
olcVf@07olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03
o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI0onA8Ih<olcVf@03o`000?o<i]Woc>KI00[oc>KI0onA8Ih9olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02_o<i]T2o`:XWP;o00000oooool001_ooooo
00?o0000on<G3?oS5``02?o<i]T00ol2Z9koc>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2
Z9h03?o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<
i]T00oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_nA8IkoTB6N00?oTB6N1oo<i]T00ol0003o
c>KIolcVf@05olcVf@GoTB6N00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNo`000?ooool00_ooool001_ooooo00Co0ZRNolcVfOo<i]Wo
haL<2?o<i]T00ol2Z9koc>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2
Z9kohaL<olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI1OnA8Ih2olcVf@03o`000?o<i]Woc>KI
00GoTB6N1Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G
3?o<i]T02_o<i]T2o`0000?ooooo000Kooooo`05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2
Z9koc>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h02oo<i]T00ol2Z9koc>KIon<G300:
olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_nA8Ih00ol0003oTB6Noi4QWP0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@09olcVf@;o00000oooool0
01_ooooo00?o0000o`:XW_o<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI
00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0;olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRN
olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<
o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@08olcVf@;o00000oooool001_ooooo00?o0000olcV
fOl2Z9h00oo<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcV
fOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_oS5`coc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T01?o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:X
W_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@07olcVf@;o00000oooool001_ooooo00?o0000olcVfOo<
i]T01?o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<
i]T02?o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ooS5`co0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI02Koc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T0
3_o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T0
3_o<i]T00ooS5`coc>KIolcVf@0`olcVf@03o`000?o<i]Woc>KI07Koc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T2o`0000?ooooo000Kooooo`03o`000?o<i]Woc>KI00Koc>KI0_oS5``?olcVf@03on<G3?o<
i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<
i]Woc>KI02ooc>KI00?o0000olcVfOo<i]T0Moo<i]T00ooS5`coc>KIolcVf@03olcVf@;o00000ooo
ool001_ooooo00?o0000olcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Wo
c>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Wo
c>KI02ooc>KI00?o0000olcVfOo<i]T0N?o<i]T00ooS5`coc>KIolcVf@02olcVf@;o00000oooool0
01_ooooo00?o0000olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI
00goc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI
02ooc>KI00?o0000olcVfOo<i]T0NOo<i]T01?oS5`coc>KIolcVfOo<i]T2o`0000?ooooo000Koooo
o`03o`000?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0=olcV
f@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@07olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI05Coc>KI00?ohaL<olcVfOo<i]T00_l00003ooooo`006oooool00ol0003o
c>KIolcVf@07olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS
5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T00_l2Z9h;olcV
f@03o`:XW_oS5`coc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?oS5`coc>KIo`000?l0
0003ooooo`004_ooool5o`0000Cooooo00?o0000olcVfOo<i]T01oo<i]T2o`:XWP;oc>KI00?ohaL<
olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRN
olcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_oS5`coc>KI00_oc>KI00Co
0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI00Co0ZRNon<G3?l0003o00000oooool001?ooooo
00Co0000oooooooooooo00001?ooool00ol0003oc>KIolcVf@09olcVf@04o`:XW_o<i]Woc>KIon<G
30Soc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9kohaL<olcVf@0;olcVf@04o`:XW_o<i]Wo
c>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0000ooooo`02ooooo`005?ooool0
0ol0003oooooooooo`04ooooo`03o`:XW_l0003o000000[o000000Co0ZRNo`000?oS5`cohaL<2?l0
00000ol2Z9ko0000o`000004o`000003on<G3?l0003o000000?o000000?o0ZRNo`000?l000001ol0
00001?oS5`co0000o`000?l2Z9h<o`000003on<G3?l0003o000000[o000000Co0ZRNo`000?l0003o
haL<2Ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00005ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002ol00003ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Booooo`05o`000?oo
ooooooooooooool00000ooooool:ooooo`004_ooool01Ol0003ooooooooooooooooo00000?oooooo
2_ooool001?ooooo0ol0003oooooo`_ooooo003oooooob7ooooo003oooooob7ooooo003oooooob7o
oooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-2.42387, -2.29536, 0.0155771, \
0.0155771}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontColor->RGBColor[0, 0, 1]]], "Section",
  InitializationCell->True],

Cell[BoxData[{
    \(\(Needs["\<Graphics`ImplicitPlot`\>"];\)\), "\n", 
    \(\t\t\(Needs["\<Graphics`Colors`\>"];\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[{
    RowBox[{"Off", "[", 
      StyleBox[\(General::spell1\),
        FontColor->RGBColor[0, 0, 1]], 
      StyleBox["]",
        FontColor->RGBColor[0, 0, 1]]}], "\n", 
    RowBox[{"Off", "[", 
      StyleBox[\(NDSolve::ndsz\),
        FontColor->RGBColor[0, 0, 1]], "]"}], "\n", 
    RowBox[{"Off", "[", 
      StyleBox[\(InterpolatingFunction::dmval\),
        FontColor->RGBColor[0, 0, 1]], "]"}], "\n", 
    RowBox[{"Off", "[", 
      StyleBox[\(Graphics::"\<gprim\>"\),
        FontColor->RGBColor[0, 0, 1]], "]"}]}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Extents[{x, a_, b_}, {y, c_, d_}] := 
      Module[{}, xL = a; xR = b; yB = c; yT = d; 
        ColumnForm[{xL \[LessEqual] x \[LessEqual] xR, 
            yB \[LessEqual] y \[LessEqual] yT}]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(len[v_] := N[\@\(v . v\)]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Mark[fexpr_, gexpr_, {x0_, y0_}, S_] := 
      Module[{t, p, q, dir}, p = fexpr /. {x \[Rule] x0, y \[Rule] y0}; 
        q = gexpr /. {x \[Rule] x0, y \[Rule] y0}; 
        dir = If[TrueQ[{p, q} \[NotEqual] {0, 0}], {p, q}/len[{p, q}], 
            Return[Circle[{x0, y0}, S/4]]]; 
        Line[{{x0, y0} - 1/2  S*dir, {x0, y0} + 1/2  S*dir}]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(PlotVectorField[fexpr_, 
        gexpr_, {x_, xL_, xR_, nx_:  20}, {y_, yB_, yT_, ny_:  20}, 
        ScaleFactor_:  0.02] := \n\t
      Module[{T, 
          Scale, \[CapitalDelta]x = N[\(xR - xL\)\/nx], \[CapitalDelta]y = 
            N[\(yT - yB\)\/ny], S}, \n\t\tScale = 
          ScaleFactor*len[{xR - xL, yB - yT}]; \n\t\tS = 
          Min[\@\(\[CapitalDelta]x*\[CapitalDelta]y\), Scale]; \n\t\tT = 
          Table[Mark[fexpr, 
              gexpr, {xL + k*\[CapitalDelta]x, yB + m*\[CapitalDelta]y}, 
              S], {k, 0, nx}, {m, 0, ny}]; 
        Show[BkGnd, myAxes, Graphics[{ManganeseBlue, T}], 
          AspectRatio \[Rule] Min[Max[ .5, \(yT - yB\)\/\(xR - xL\)], 2], 
          Frame \[Rule] True]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(theHorizNullclines := 
      Module[{FF = Factor[yf[x, y]], L, k}, 
        L = If[TrueQ[Head[FF] == Times], Length[FF], FF = {FF}; 1]; 
        Table[Graphics[
            ImplicitPlot[
              FF[\([k]\)] == 0, {x, xL, xR}, {y, yB, 
                yT}, \n\t\t\tPlotPoints \[Rule] 
                25, \n\t\tPlotStyle \[Rule] {{SteelBlue, Thickness[ .005]}}, 
              DisplayFunction \[RuleDelayed] Identity]], {k, 1, 
            L}]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(theVertNullclines := 
      Module[{FF = Factor[xf[x, y]], L, k}, 
        L = If[TrueQ[Head[FF] == Times], Length[FF], FF = {FF}; 1]; 
        Table[Graphics[
            ImplicitPlot[
              FF[\([k]\)] == 0, {x, xL, xR}, {y, yB, 
                yT}, \n\t\t\tPlotPoints \[Rule] 
                25, \n\t\tPlotStyle \[Rule] {{DeepCobaltViolet, 
                    Thickness[ .005]}}, 
              DisplayFunction \[RuleDelayed] Identity]], {k, 1, 
            L}]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Nullclines := {theVertNullclines, theHorizNullclines}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(s[t_, a_, b_]\), ":=", 
      RowBox[{\({x[t], y[t]}\), "/.", 
        RowBox[{"First", "[", 
          RowBox[{"NDSolve", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], 
                    "==", \(yf[x[t], y[t]]\)}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["x", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], 
                    "==", \(xf[x[t], y[t]]\)}], ",", \(x[0] == a\), 
                  ",", \(y[0] == b\)}], "}"}], ",", \({x[t], y[t]}\), 
              ",", \({t, \(-10\), 10}\), 
              ",", \(StoppingTest \[Rule] \((x[t] < xL || x[t] > xR || 
                    y[t] < yB || y[t] > yT)\)\), 
              ",", \(MaxStepSize \[Rule] 0.1\)}], "]"}], "]"}]}]}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{\(DoPP[{a1_, b1_}]\), ":=", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"v", "=", 
                RowBox[{"s", "[", \(t, a1, b1\), 
                  StyleBox["]",
                    "Subsection"]}]}], "}"}], ",", 
            RowBox[{"ParametricPlot", "[", 
              RowBox[{
                RowBox[{"Evaluate", "[", "v", 
                  StyleBox["]",
                    "Subsection"]}], 
                ",", \({t, v[\([1, 0, 1, 1, 1]\)], v[\([1, 0, 1, 1, 2]\)]}\), 
                ",", \(PlotRange -> {{xL, xR}, {yB, yT}}\), 
                ",", \(PlotStyle \[Rule] {{DeepCadmiumRed, 
                      Thickness[ .005]}}\), 
                ",", \(DisplayFunction \[RuleDelayed] Identity\)}], "]"}]}], 
          "]"}]}], ";"}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AllSolutions := Map[DoPP, thePoints];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(BkGnd := 
      Graphics[{RGBColor[ .8,  .9,  .85], Rectangle[{xL, yB}, {xR, yT}], 
          Black, Thickness[0.01], 
          Line[{{xL, yB}, {xR, yB}, {xR, yT}, {xL, yT}, {xL, 
                yB}}]}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(myAxes := 
      Graphics[{Line[{{xL, 0}, {xR, 0}}], 
          Line[{{0, yB}, {0, yT}}]}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(DisplayAll := 
        Show[DirFld, Nullclines, AllSolutions, myAxes, 
          DisplayFunction \[RuleDelayed] $DisplayFunction, 
          PlotRange -> {{xL, xR}, {yB, yT}}, 
          AspectRatio \[Rule] Min[Max[ .5, \(yT - yB\)\/\(xR - xL\)], 2], 
          Frame \[Rule] True];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowSize->{598, 515},
WindowMargins->{{17, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 226, 6, 139, "Subtitle"],

Cell[CellGroupData[{
Cell[2027, 63, 108, 4, 59, "Section"],

Cell[CellGroupData[{
Cell[2160, 71, 133, 3, 43, "Input"],
Cell[2296, 76, 61, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2394, 82, 139, 3, 43, "Input"],
Cell[2536, 87, 61, 1, 29, "Output"]
}, Open  ]],
Cell[2612, 91, 99, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[2736, 98, 151, 4, 43, "Input"],
Cell[2890, 104, 360, 10, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3287, 119, 27, 0, 46, "Subsection"],
Cell[3317, 121, 40, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[3382, 125, 80, 1, 44, "Input"],
Cell[3465, 128, 123, 2, 49, "Output"]
}, Open  ]],
Cell[3603, 133, 24, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[3652, 137, 129, 2, 43, "Input"],
Cell[3784, 141, 1213, 37, 49, "Output"]
}, Open  ]],
Cell[5012, 181, 74, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5123, 186, 38, 0, 46, "Subsection"],

Cell[CellGroupData[{
Cell[5186, 190, 136, 3, 43, "Input"],
Cell[5325, 195, 107682, 2790, 296, 19057, 1691, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[113056, 2991, 60, 0, 46, "Subsection"],
Cell[113119, 2993, 1230, 40, 122, "Text"],

Cell[CellGroupData[{
Cell[114374, 3037, 78, 1, 27, "Input"],
Cell[114455, 3040, 218, 4, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[114710, 3049, 78, 1, 27, "Input"],
Cell[114791, 3052, 369, 5, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115197, 3062, 73, 1, 27, "Input"],
Cell[115273, 3065, 282, 4, 59, "Output"]
}, Open  ]],
Cell[115570, 3072, 66, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115673, 3078, 63, 0, 46, "Subsection"],

Cell[CellGroupData[{
Cell[115761, 3082, 48, 1, 27, "Input"],
Cell[115812, 3085, 170664, 5752, 302, 47157, 4223, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[286537, 8844, 113, 2, 56, "Section",
  InitializationCell->True],
Cell[286653, 8848, 158, 3, 43, "Input",
  InitializationCell->True],
Cell[286814, 8853, 574, 15, 75, "Input",
  InitializationCell->True],
Cell[287391, 8870, 253, 5, 59, "Input",
  InitializationCell->True],
Cell[287647, 8877, 86, 2, 33, "Input",
  InitializationCell->True],
Cell[287736, 8881, 405, 7, 107, "Input",
  InitializationCell->True],
Cell[288144, 8890, 780, 15, 238, "Input",
  InitializationCell->True],
Cell[288927, 8907, 510, 11, 155, "Input",
  InitializationCell->True],
Cell[289440, 8920, 537, 12, 155, "Input",
  InitializationCell->True],
Cell[289980, 8934, 114, 2, 27, "Input",
  InitializationCell->True],
Cell[290097, 8938, 1050, 23, 107, "Input",
  InitializationCell->True],
Cell[291150, 8963, 884, 21, 107, "Input",
  InitializationCell->True],
Cell[292037, 8986, 102, 2, 27, "Input",
  InitializationCell->True],
Cell[292142, 8990, 265, 6, 75, "Input",
  InitializationCell->True],
Cell[292410, 8998, 151, 4, 43, "Input",
  InitializationCell->True],
Cell[292564, 9004, 347, 7, 95, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

